/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./bin/classes/App.js":
/*!****************************!*\
  !*** ./bin/classes/App.js ***!
  \****************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.App = void 0;
const GUIController_1 = __webpack_require__(/*! ./appControllers/GUIController */ "./bin/classes/appControllers/GUIController.js");
const StateDashboard_1 = __webpack_require__(/*! ./states/StateDashboard */ "./bin/classes/states/StateDashboard.js");
const gs_1 = __webpack_require__(/*! @ivanlog/gs */ "./node_modules/@ivanlog/gs/index.js");
const StateUp_1 = __webpack_require__(/*! ./states/abstracts/StateUp */ "./bin/classes/states/abstracts/StateUp.js");
const StateLoading_1 = __webpack_require__(/*! ./states/StateLoading */ "./bin/classes/states/StateLoading.js");
const DesignThemeEnum_1 = __webpack_require__(/*! ./enums/DesignThemeEnum */ "./bin/classes/enums/DesignThemeEnum.js");
const Web3Controller_1 = __webpack_require__(/*! ./appControllers/Web3Controller */ "./bin/classes/appControllers/Web3Controller.js");
class App {
    constructor() {
        App.Inst = this;
        StateUp_1.StateUp.App = this;
        gs_1.StateGS.DefaultStateName = 'loading';
        this.gui = new GUIController_1.GUIController(this);
        this.chain = new Web3Controller_1.Web3Controller(this);
        this.gui.setTheme(DesignThemeEnum_1.DesignThemeEnum.LightGrey);
        this.start();
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
            gs_1.StateGS.RegState(StateLoading_1.StateLoading);
            gs_1.StateGS.RegState(StateDashboard_1.StateDashboard);
            gs_1.StateGS.DefaultStateName = StateDashboard_1.StateDashboard.StateName;
            yield gs_1.StateGS.Run(StateLoading_1.StateLoading);
            yield this.chain.start();
            if (this.chain.isConnected) {
                yield gs_1.StateGS.Run(StateDashboard_1.StateDashboard);
                // const byUrl = await StateGS.RunByUrl()
                // if (byUrl === StateRunResultEnum.Failed) 
            }
            else {
                yield gs_1.StateGS.Run(StateLoading_1.StateLoading);
            }
        });
    }
}
exports.App = App;
App.ADDRESS_upManager = "0x2d438666853205901f63940775a38F3c88ed3Aa5";
App.ADDRESS_upValidatorsFee = "0x496Cf17010A986F43093fC0a6DAFaccF0059234c";
App.version = "1.0.3";
//# sourceMappingURL=App.js.map

/***/ }),

/***/ "./bin/classes/appControllers/AppControllerBase.js":
/*!*********************************************************!*\
  !*** ./bin/classes/appControllers/AppControllerBase.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AppControllerBase = void 0;
class AppControllerBase {
    constructor(app) {
        this.app = app;
    }
    lockgui(action) {
        return __awaiter(this, void 0, void 0, function* () { return this.app.gui.lockAction(action); });
    }
}
exports.AppControllerBase = AppControllerBase;
//# sourceMappingURL=AppControllerBase.js.map

/***/ }),

/***/ "./bin/classes/appControllers/GUIController.js":
/*!*****************************************************!*\
  !*** ./bin/classes/appControllers/GUIController.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GUIController = void 0;
const gs = __webpack_require__(/*! @ivanlog/gs */ "./node_modules/@ivanlog/gs/index.js");
const UpTopNavBar_1 = __webpack_require__(/*! ../com/UpTopNavBar */ "./bin/classes/com/UpTopNavBar.js");
const DesignThemeEnum_1 = __webpack_require__(/*! ../enums/DesignThemeEnum */ "./bin/classes/enums/DesignThemeEnum.js");
const AppControllerBase_1 = __webpack_require__(/*! ./AppControllerBase */ "./bin/classes/appControllers/AppControllerBase.js");
class GUIController extends AppControllerBase_1.AppControllerBase {
    constructor(app) {
        super(app);
        this._lockCounter = 0;
        this._body = gs.q('body').first;
        this._container = gs.q('main').first;
        this._tabsContainer = gs.q('.asap-tabs_container').first;
        this._topNavBar = new UpTopNavBar_1.UpTopNavBar(app);
        this._body.prepend(this._topNavBar);
        this._topNavBar.hide();
    }
    get topBar() {
        return this._topNavBar;
    }
    setTabs(tabs) {
        this._tabsContainer.html = '';
        this._tabsContainer.append(tabs);
    }
    clearTabs() { this._tabsContainer.html = ''; }
    showPage(page) {
        if (this._page)
            this._page.cut();
        this._page = page;
        this._container.append(page);
        const newTheme = page.getData('theme');
        if (newTheme) {
            const themeEnum = DesignThemeEnum_1.DesignThemeEnum[newTheme];
            if (themeEnum)
                this.setTheme(themeEnum);
        }
        page.show();
    }
    hidePage() {
        if (!this._page)
            return;
        this._page.cut();
        this._page = undefined;
    }
    lock() {
        if (this._lockCounter === 0)
            this._container.disable();
        this._lockCounter++;
    }
    unlock() {
        this._lockCounter--;
        if (this._lockCounter === 0)
            this._container.enable();
    }
    lockAction(action) {
        return __awaiter(this, void 0, void 0, function* () {
            this.app.gui.lock();
            const r = yield action;
            this.app.gui.unlock();
            return r;
        });
    }
    setTheme(theme) {
        for (const i in this._body.el.classList) {
            const c = this._body.el.classList[i];
            if (!c)
                continue;
            if (c.indexOf)
                if (c.indexOf('theme') === 0)
                    this._body.removeClass(c);
        }
        if (theme)
            this._body.addClass(`theme_${theme}`);
    }
}
exports.GUIController = GUIController;
//# sourceMappingURL=GUIController.js.map

/***/ }),

/***/ "./bin/classes/appControllers/Web3Controller.js":
/*!******************************************************!*\
  !*** ./bin/classes/appControllers/Web3Controller.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Web3Controller = void 0;
const AppControllerBase_1 = __webpack_require__(/*! ./AppControllerBase */ "./bin/classes/appControllers/AppControllerBase.js");
const App_1 = __webpack_require__(/*! ../App */ "./bin/classes/App.js");
const PriceKeeperContract_1 = __webpack_require__(/*! ../contracts/PriceKeeperContract */ "./bin/classes/contracts/PriceKeeperContract.js");
const UpManagerContract_1 = __webpack_require__(/*! ../contracts/UpManagerContract */ "./bin/classes/contracts/UpManagerContract.js");
const LiquidControllerContract_1 = __webpack_require__(/*! ../contracts/LiquidControllerContract */ "./bin/classes/contracts/LiquidControllerContract.js");
const BuyBurnPoolContract_1 = __webpack_require__(/*! ../contracts/BuyBurnPoolContract */ "./bin/classes/contracts/BuyBurnPoolContract.js");
const StabilityPoolContract_1 = __webpack_require__(/*! ../contracts/StabilityPoolContract */ "./bin/classes/contracts/StabilityPoolContract.js");
const InternalExchangerBnBContract_1 = __webpack_require__(/*! ../contracts/InternalExchangerBnBContract */ "./bin/classes/contracts/InternalExchangerBnBContract.js");
const InternalExchangerSPContract_1 = __webpack_require__(/*! ../contracts/InternalExchangerSPContract */ "./bin/classes/contracts/InternalExchangerSPContract.js");
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const ShareXContract_1 = __webpack_require__(/*! ../contracts/ShareXContract */ "./bin/classes/contracts/ShareXContract.js");
const BurnableContract_1 = __webpack_require__(/*! ../contracts/BurnableContract */ "./bin/classes/contracts/BurnableContract.js");
const ValidatorFeeReceiverContract_1 = __webpack_require__(/*! ../contracts/ValidatorFeeReceiverContract */ "./bin/classes/contracts/ValidatorFeeReceiverContract.js");
const ValidatorStatsCollectorContract_1 = __webpack_require__(/*! ../contracts/ValidatorStatsCollectorContract */ "./bin/classes/contracts/ValidatorStatsCollectorContract.js");
const ValidatorBnBContract_1 = __webpack_require__(/*! ../contracts/ValidatorBnBContract */ "./bin/classes/contracts/ValidatorBnBContract.js");
class Web3Controller extends AppControllerBase_1.AppControllerBase {
    constructor(app) {
        super(app);
        this._liquidControllers = [];
    }
    get isConnected() { return this._web3 != undefined; }
    get web3() { return this._web3; }
    get account() { return this._account; }
    get addressTokenUSDL() { return this._addressTokenUSDL; }
    get addressTokenLOAN() { return this._addressTokenLOAN; }
    get addressTokenUP() { return this._addressTokenUP; }
    get addressPriceKeeperPLS() { return this._addressPriceKeeperPLS; }
    get addressPriceKeeperUP() { return this._addressPriceKeeperUP; }
    get internalExchangerBnB() { return this._internalExchangerBnB; }
    get internalExchangerSP() { return this._internalExchangerSP; }
    get priceKeeperPLS() { return this._priceKeeperPLS; }
    get priceKeeperUP() { return this._priceKeeperUP; }
    get upManager() { return this._upManager; }
    get buyBurnPool() { return this._buyBurnPool; }
    get stabilityPool() { return this._stabilityPool; }
    get burnableUp() { return this._burnableUp; }
    get shareX() { return this._shareX; }
    get liquidControllers() { return this._liquidControllers.slice(); }
    get validatorsManager() { return this._validatorsManager; }
    get validatorsStats() { return this._validatorsStats; }
    get validatorsBnB() { return this._validatorsBnB; }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.initWeb3();
        });
    }
    getAccountAsync() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this._account)
                return this._account;
            const eth = globalThis.ethereum;
            //chain validation
            const currentChainId = yield eth.request({ method: 'eth_chainId' });
            if (currentChainId != 369) {
                new modalCom.DialogOk("Wrong blockchain selected. Change blockchain and refresh page.").show();
                return;
            }
            const accounts = yield eth.request({ method: 'eth_requestAccounts' });
            this._account = accounts[0];
            this._web3 = new globalThis.Web3(eth);
            this._upManager.updateWeb3(this._web3);
            this._priceKeeperPLS.updateWeb3(this._web3);
            this._priceKeeperUP.updateWeb3(this._web3);
            this._buyBurnPool.updateWeb3(this._web3);
            this._stabilityPool.updateWeb3(this._web3);
            this._shareX.updateWeb3(this._web3);
            this._burnableUp.updateWeb3(this._web3);
            this._validatorsManager.updateWeb3(this._web3);
            this._validatorsStats.updateWeb3(this._web3);
            this._validatorsBnB.updateWeb3(this._web3);
            for (const contract of this._liquidControllers)
                contract.updateWeb3(this._web3);
        });
    }
    initWeb3() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                this._web3 = new globalThis.Web3(new globalThis.Web3.providers.HttpProvider("https://rpc.pulsechain.com"));
                this._upManager = new UpManagerContract_1.UpManagerContract(App_1.App.ADDRESS_upManager, this._web3);
                this._validatorsManager = new ValidatorFeeReceiverContract_1.ValidatorFeeReceiverContract(App_1.App.ADDRESS_upValidatorsFee, this._web3);
                const validatorStatsAddress = yield this._validatorsManager.getStatsCollectorAddress();
                this._validatorsStats = new ValidatorStatsCollectorContract_1.ValidatorStatsCollectorContract(validatorStatsAddress, this._web3);
                const validatorBnBStatsAddress = yield this._validatorsManager.getBnbAddress();
                this._validatorsBnB = new ValidatorBnBContract_1.ValidatorBnBContract(validatorBnBStatsAddress, this._web3);
                this._addressPriceKeeperPLS = yield this._upManager.getPriceKeeperPLS();
                this._addressPriceKeeperUP = yield this._upManager.getPriceKeeperUP();
                this._addressTokenUSDL = yield this._upManager.getTokenUSDL();
                this._addressTokenLOAN = yield this._upManager.getTokenLOAN();
                this._addressTokenUP = yield this._upManager.getTokenUP();
                this._priceKeeperPLS = new PriceKeeperContract_1.PriceKeeperContract(this.addressPriceKeeperPLS, this._web3);
                this._priceKeeperUP = new PriceKeeperContract_1.PriceKeeperContract(this.addressPriceKeeperUP, this._web3);
                this._buyBurnPool = new BuyBurnPoolContract_1.BuyBurnPoolContract(yield this._upManager.getBuyBurnPool(), this._web3);
                this._stabilityPool = new StabilityPoolContract_1.StabilityPoolContract(yield this._upManager.getStabilityPool(), this._web3);
                this._internalExchangerBnB = new InternalExchangerBnBContract_1.InternalExchangerBnBContract(yield this._upManager.getInternalExchangerBnB(), this._web3);
                this._internalExchangerSP = new InternalExchangerSPContract_1.InternalExchangerSPContract(yield this._upManager.getInternalExchangerSP(), this._web3);
                this._burnableUp = new BurnableContract_1.BurnableContract(this._addressTokenUP, this._web3);
                this._shareX = new ShareXContract_1.ShareXContract(yield this._upManager.getRewardPool(), this._web3);
                if (yield this._upManager.getStarted()) {
                    const firstVault = yield this._upManager.getLiquidController(0);
                    if (firstVault.count != 0)
                        this._liquidControllers.push(new LiquidControllerContract_1.LiquidControllerContract(firstVault.liquidController, this._web3, 0));
                    let i = 1;
                    while (i < firstVault.count) {
                        const data = yield this._upManager.getLiquidController(i);
                        this._liquidControllers.push(new LiquidControllerContract_1.LiquidControllerContract(data.liquidController, this._web3, i));
                        i++;
                    }
                }
            }
            catch (e) {
                new modalCom.DialogOk(e).show();
            }
        });
    }
    ethToFormat(eth, del = 3) {
        //del - сколько знаков после запятой справа будет после череды нулей
        if (eth == "0.")
            return "0";
        const spliter = eth.split('.');
        let a = spliter[0];
        let result = "";
        let c = 0;
        for (let i = a.length - 1; i >= 0; i--) {
            result = a[i] + result;
            c++;
            if (c % 3 == 0 && i != 0) {
                result = "," + result;
            }
        }
        if (spliter.length == 1)
            return result;
        if (del == 0)
            return result;
        let b = spliter[1];
        if (b.length == 1)
            b = b + "0";
        let tb = "";
        let bc = 0;
        for (let i = 0; i < b.length; i++) {
            if (bc < del)
                tb += b[i];
            if (bc == 0 && b[i] == "0")
                continue;
            bc++;
        }
        b = tb;
        if (result.length < 2)
            return result + "." + b;
        else
            return result + "." + b.slice(0, 2);
    }
}
exports.Web3Controller = Web3Controller;
//# sourceMappingURL=Web3Controller.js.map

/***/ }),

/***/ "./bin/classes/com/UpTopNavBar.js":
/*!****************************************!*\
  !*** ./bin/classes/com/UpTopNavBar.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpTopNavBar = void 0;
const gs = __webpack_require__(/*! @ivanlog/gs */ "./node_modules/@ivanlog/gs/index.js");
const com = __webpack_require__(/*! ./tmpls */ "./bin/classes/com/tmpls.js");
class UpTopNavBar extends com.TopNavBar {
    constructor(app) {
        super();
        this.app = app;
        this._body = gs.q('body').first;
    }
    show() {
        this._body.addClass('with_top_bar');
        super.show();
    }
    hide() {
        this._body.removeClass('with_top_bar');
        super.hide();
    }
}
exports.UpTopNavBar = UpTopNavBar;
//# sourceMappingURL=UpTopNavBar.js.map

/***/ }),

/***/ "./bin/classes/com/contractViews/BuyBurnPoolView.js":
/*!**********************************************************!*\
  !*** ./bin/classes/com/contractViews/BuyBurnPoolView.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BuyBurnPoolView = void 0;
const ERC20Contract_1 = __webpack_require__(/*! ../../contracts/ERC20Contract */ "./bin/classes/contracts/ERC20Contract.js");
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const com = __webpack_require__(/*! ../tmpls */ "./bin/classes/com/tmpls.js");
const App_1 = __webpack_require__(/*! ../../App */ "./bin/classes/App.js");
class BuyBurnPoolView extends com.CmpBuyBurnPool {
    constructor(contract) {
        super();
        this._contract = contract;
        this.ctrls.btnInfo.onclick = () => new modalCom.DialogOk("Contract address: " + this._contract.address + "<br><br>" + this.ctrls.lFaqInfo.text, "Info").show();
        this.ctrls.btnRefresh.onclick = () => this.refresh();
        this.ctrls.btnUpdate.onclick = () => this.update();
        this.ctrls.btnDepositeUSDL.onclick = () => this.depositeUSDL();
        this.ctrls.btnDepositeLOAN.onclick = () => this.depositeLOAN();
        this.ctrls.btnDepositeUP.onclick = () => this.depositeUP();
    }
    refresh() {
        return __awaiter(this, void 0, void 0, function* () {
            const needUpdate = yield this._contract.needUpdate();
            if (needUpdate)
                this.ctrls.btnUpdate.enable();
            else
                this.ctrls.btnUpdate.disable();
            this.ctrls.lBalancePLS.text = yield this._contract.getBalance();
            this.ctrls.lBalanceUSDL.text = yield this._contract.getBalanceToken(App_1.App.Inst.chain.addressTokenUSDL);
            this.ctrls.lBalanceLOAN.text = yield this._contract.getBalanceToken(App_1.App.Inst.chain.addressTokenLOAN);
            this.ctrls.lStakedUSDL.text = yield this._contract.getStakedUSDL();
            this.ctrls.lStakedLOAN.text = yield this._contract.getStakedLOAN();
            const stabReward = yield this._contract.getPendingGainForUSDL();
            this.ctrls.lStabilityRewardPLS.text = stabReward.pls;
            this.ctrls.lStabilityRewardLOAN.text = stabReward.loan;
            const stakeReward = yield this._contract.getPendingGainForLOAN();
            this.ctrls.lStakeRewardPLS.text = stakeReward.pls;
            this.ctrls.lStakeRewardUSDL.text = stakeReward.usdl;
            this.ctrls.lForSwapUSDL.text = yield this._contract.getForSwapUSDL();
            this.ctrls.lPriceATH.text = yield this._contract.getPriceATH();
            this.ctrls.lForSwapUSDL.text = yield this._contract.getForSwapUSDL();
            this.ctrls.lLastUpdateTime.text = yield this._contract.getLastUpdateTimestamp();
            this.ctrls.lPreBnBSeqTime.text = yield this._contract.getPreBnBSeqTimestamp();
            this.ctrls.lBotPriority.text = 'no';
            if (yield this._contract.getPreBnBSeqTimestamp())
                this.ctrls.lBotPriority.text = 'yes';
        });
    }
    // async deposit()
    // {
    //     const value = parseFloat(this.ctrls.iDeposit.value);
    //     if (!value) return;
    //     this._contract.deposit(value+"");
    // }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            yield this._contract.update();
        });
    }
    depositeUSDL() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            const value = parseFloat(this.ctrls.iValue.value);
            if (!value)
                return;
            var erc20 = new ERC20Contract_1.ERC20Contract(App_1.App.Inst.chain.addressTokenUSDL, App_1.App.Inst.chain.web3);
            erc20.transfer(this._contract.address, value + "");
        });
    }
    depositeLOAN() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            const value = parseFloat(this.ctrls.iValueLOAN.value);
            if (!value)
                return;
            var erc20 = new ERC20Contract_1.ERC20Contract(App_1.App.Inst.chain.addressTokenLOAN, App_1.App.Inst.chain.web3);
            erc20.transfer(this._contract.address, value + "");
        });
    }
    depositeUP() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            const value = parseFloat(this.ctrls.iValue.value);
            if (!value)
                return;
            var erc20 = new ERC20Contract_1.ERC20Contract(App_1.App.Inst.chain.addressTokenUP, App_1.App.Inst.chain.web3);
            erc20.transfer(this._contract.address, value + "");
        });
    }
}
exports.BuyBurnPoolView = BuyBurnPoolView;
//# sourceMappingURL=BuyBurnPoolView.js.map

/***/ }),

/***/ "./bin/classes/com/contractViews/InternalExchangerBnBView.js":
/*!*******************************************************************!*\
  !*** ./bin/classes/com/contractViews/InternalExchangerBnBView.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InternalExchangerBnBView = void 0;
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const com = __webpack_require__(/*! ../tmpls */ "./bin/classes/com/tmpls.js");
class InternalExchangerBnBView extends com.CmpInternalExchanger {
    constructor(contract) {
        super();
        this._contract = contract;
        this.ctrls.lName.text = "Internal exchange BnB";
        this.ctrls.btnRefresh.onclick = () => this.refresh();
        this.ctrls.btnInfo.onclick = () => new modalCom.DialogOk("Contract address: " + this._contract.address + "<br><br>" + this.ctrls.lFaqInfo.text, "Info").show();
    }
    refresh() {
        return __awaiter(this, void 0, void 0, function* () {
            this.ctrls.lBalancePLS.text = yield this._contract.getBalance();
        });
    }
}
exports.InternalExchangerBnBView = InternalExchangerBnBView;
//# sourceMappingURL=InternalExchangerBnBView.js.map

/***/ }),

/***/ "./bin/classes/com/contractViews/InternalExchangerSPView.js":
/*!******************************************************************!*\
  !*** ./bin/classes/com/contractViews/InternalExchangerSPView.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InternalExchangerSPView = void 0;
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const com = __webpack_require__(/*! ../tmpls */ "./bin/classes/com/tmpls.js");
class InternalExchangerSPView extends com.CmpInternalExchanger {
    constructor(contract) {
        super();
        this._contract = contract;
        this.ctrls.lName.text = "Internal exchange SP";
        this.ctrls.btnRefresh.onclick = () => this.refresh();
        this.ctrls.btnInfo.onclick = () => new modalCom.DialogOk("Contract address: " + this._contract.address + "<br><br>" + this.ctrls.lFaqInfo.text, "Info").show();
    }
    refresh() {
        return __awaiter(this, void 0, void 0, function* () {
            this.ctrls.lBalancePLS.text = yield this._contract.getBalance();
        });
    }
}
exports.InternalExchangerSPView = InternalExchangerSPView;
//# sourceMappingURL=InternalExchangerSPView.js.map

/***/ }),

/***/ "./bin/classes/com/contractViews/LiquidControllerView.js":
/*!***************************************************************!*\
  !*** ./bin/classes/com/contractViews/LiquidControllerView.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LiquidControllerView = void 0;
const ERC20Contract_1 = __webpack_require__(/*! ../../contracts/ERC20Contract */ "./bin/classes/contracts/ERC20Contract.js");
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const com = __webpack_require__(/*! ../tmpls */ "./bin/classes/com/tmpls.js");
const App_1 = __webpack_require__(/*! ../../App */ "./bin/classes/App.js");
const VaultControllerStatusEnum_1 = __webpack_require__(/*! ../../enums/VaultControllerStatusEnum */ "./bin/classes/enums/VaultControllerStatusEnum.js");
class LiquidControllerView extends com.CmpUpVaultController {
    constructor(contract) {
        super();
        this._contract = contract;
        this.ctrls.btnInfo.onclick = () => new modalCom.DialogOk("Contract address: " + this._contract.address + "<br><br>" + this.ctrls.lFaqInfo.text, "Info").show();
        this.ctrls.btnRefresh.onclick = () => this.refresh();
        this.ctrls.btnUpdate.onclick = () => this.update();
        this.ctrls.btnUpdate.disable();
        this.ctrls.btnDepositeUSDL.onclick = () => this.depositeUSDL();
        this.ctrls.btnDepositePLS.onclick = () => this.depositePLS();
        // this.ctrls.btnSave.onclick = () => this.saveDumpIndex();
        this._init();
    }
    _init() {
        return __awaiter(this, void 0, void 0, function* () {
            this.ctrls.lLabel.text = (yield this._contract.id) + "";
        });
    }
    refresh() {
        return __awaiter(this, void 0, void 0, function* () {
            const needUpdate = yield this._contract.needUpdate();
            if (needUpdate)
                this.ctrls.btnUpdate.enable();
            else
                this.ctrls.btnUpdate.disable();
            const status = parseInt(yield this._contract.getStatus());
            this.ctrls.lStatus.text = VaultControllerStatusEnum_1.VaultControllerStatusEnum[status];
            this.ctrls.lBalance.text = yield this._contract.getBalance();
            this.ctrls.lBalanceUSDL.text = yield this._contract.getBalanceToken(App_1.App.Inst.chain.addressTokenUSDL);
            this.ctrls.lICR.text = parseFloat(yield this._contract.getICR()) * 100 + "";
            this.ctrls.lDebt.text = yield this._contract.getDebt();
            this.ctrls.lColl.text = yield this._contract.getColl();
            const cnf = yield this._contract.getConfig();
            this.ctrls.lTargetICR.text = parseFloat(cnf.targetICR) * 100 + "";
            this.ctrls.lTargetReloanICR.text = parseFloat(cnf.targetReloanICR) * 100 + "";
            this.ctrls.lllMinLoan.text = cnf.llMinLoan;
            this.ctrls.lllGas.text = cnf.llGas;
            this.ctrls.lLoanMinReTakeUSDL.text = cnf.loanMinReTakeUSDL;
            this.ctrls.lSwapMinUSDL.text = cnf.swapMinUSDL;
            this.ctrls.lMaxLoanDumpIndex.text = cnf.maxLoanDumpIndex;
            this.ctrls.lStabPoolSplitPartRever.text = cnf.stabPoolSplitPartRevers;
            this.ctrls.lBuyBurnSplitPartRevers.text = cnf.buyBurnSplitPartRevers;
        });
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            yield this._contract.update();
        });
    }
    // async saveDumpIndex()
    // {
    //     const index = parseFloat(this.ctrls.iDumpIndex.value);
    //     if (!index) return;
    //     this._contract.setMaxSwapDumpIndex(index);
    // }
    depositeUSDL() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            const value = parseFloat(this.ctrls.iValueUSDL.value);
            if (!value)
                return;
            var erc20 = new ERC20Contract_1.ERC20Contract(App_1.App.Inst.chain.addressTokenUSDL, App_1.App.Inst.chain.web3);
            erc20.transfer(this._contract.address, value + "");
        });
    }
    depositePLS() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            const value = parseFloat(this.ctrls.iValuePLS.value);
            if (!value)
                return;
            this._contract.deposit(value + "");
        });
    }
}
exports.LiquidControllerView = LiquidControllerView;
//# sourceMappingURL=LiquidControllerView.js.map

/***/ }),

/***/ "./bin/classes/com/contractViews/PriceKeeperView.js":
/*!**********************************************************!*\
  !*** ./bin/classes/com/contractViews/PriceKeeperView.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PriceKeeperView = void 0;
const ERC20Contract_1 = __webpack_require__(/*! ../../contracts/ERC20Contract */ "./bin/classes/contracts/ERC20Contract.js");
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const com = __webpack_require__(/*! ../tmpls */ "./bin/classes/com/tmpls.js");
class PriceKeeperView extends com.CmpPriceKeeper {
    constructor(contract, asset) {
        super();
        this._contract = contract;
        this._init();
        this.ctrls.btnInfo.onclick = () => new modalCom.DialogOk("Contract address: " + this._contract.address + "<br><br>" + this.ctrls.lFaqInfo.text, "Info").show();
        this.ctrls.btnRefresh.onclick = () => this.refresh();
        this._asset = asset;
    }
    _init() {
        return __awaiter(this, void 0, void 0, function* () {
            const token = yield this._contract.getQuoteToken();
            const erc20 = new ERC20Contract_1.ERC20Contract(token, this._contract.web3);
            this._tokenName = yield erc20.symbol();
            this.ctrls.lTokenAddress.text = token;
            this.ctrls.lToken.text = `Price ${this._tokenName}:`;
        });
    }
    refresh() {
        return __awaiter(this, void 0, void 0, function* () {
            this.ctrls.btnRefresh.disable();
            let price = (yield this._contract.getPrice()) + "";
            this._lastPrice = price;
            this.ctrls.btnRefresh.enable();
            let pre = price;
            let post = "";
            let dotIndex = price.indexOf('.');
            if (dotIndex < 20)
                price = price.slice(0, 20);
            else
                price = price.slice(0, dotIndex);
            if (price.length > 7) {
                pre = price.slice(0, dotIndex + 7);
                post = price.slice(dotIndex + 7);
            }
            this.ctrls.lPrice.html = `<span>${pre}</span><span>${post}</span> ${this._asset}`;
        });
    }
    getLastPrice() {
        return this._lastPrice;
    }
}
exports.PriceKeeperView = PriceKeeperView;
//# sourceMappingURL=PriceKeeperView.js.map

/***/ }),

/***/ "./bin/classes/com/contractViews/StabilityPoolView.js":
/*!************************************************************!*\
  !*** ./bin/classes/com/contractViews/StabilityPoolView.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StabilityPoolView = void 0;
const ERC20Contract_1 = __webpack_require__(/*! ../../contracts/ERC20Contract */ "./bin/classes/contracts/ERC20Contract.js");
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const com = __webpack_require__(/*! ../tmpls */ "./bin/classes/com/tmpls.js");
const App_1 = __webpack_require__(/*! ../../App */ "./bin/classes/App.js");
class StabilityPoolView extends com.CmpStabilityPool {
    constructor(contract) {
        super();
        this._contract = contract;
        this.ctrls.btnInfo.onclick = () => new modalCom.DialogOk("Contract address: " + this._contract.address + "<br><br>" + this.ctrls.lFaqInfo.text, "Info").show();
        this.ctrls.btnRefresh.onclick = () => this.refresh();
        this.ctrls.btnUpdate.onclick = () => this.update();
        this.ctrls.btnDepositeLOAN.onclick = () => this.depositeLOAN();
        this.ctrls.btnDepositeUSDL.onclick = () => this.depositeUSDL();
    }
    refresh() {
        return __awaiter(this, void 0, void 0, function* () {
            const needUpdate = yield this._contract.needUpdate();
            if (needUpdate)
                this.ctrls.btnUpdate.enable();
            else
                this.ctrls.btnUpdate.disable();
            this.ctrls.lBalancePLS.text = yield this._contract.getBalance();
            this.ctrls.lBalanceUSDL.text = yield this._contract.getBalanceToken(App_1.App.Inst.chain.addressTokenUSDL);
            this.ctrls.lBalanceLOAN.text = yield this._contract.getBalanceToken(App_1.App.Inst.chain.addressTokenLOAN);
            this.ctrls.lStakedUSDL.text = yield this._contract.getStakedUSDL();
            this.ctrls.lStakedLOAN.text = yield this._contract.getStakedLOAN();
            const stabReward = yield this._contract.getPendingGainForUSDL();
            this.ctrls.lStabilityRewardPLS.text = stabReward.pls;
            this.ctrls.lStabilityRewardLOAN.text = stabReward.loan;
            const stakeReward = yield this._contract.getPendingGainForLOAN();
            this.ctrls.lStakeRewardPLS.text = stakeReward.pls;
            this.ctrls.lStakeRewardUSDL.text = stakeReward.usdl;
            this.ctrls.lPricePLS_ATH.text = yield this._contract.getPricePLS_ATH();
            this.ctrls.lInSwapMode.text = "no";
            if (yield this._contract.getInSwapMode())
                this.ctrls.lInSwapMode.text = "yes";
            this.ctrls.lLastUpdateTime.text = yield this._contract.getLastUpdateTimestamp();
        });
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            yield this._contract.update();
        });
    }
    depositeLOAN() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            const value = parseFloat(this.ctrls.iValueLOAN.value);
            if (!value)
                return;
            var erc20 = new ERC20Contract_1.ERC20Contract(App_1.App.Inst.chain.addressTokenLOAN, App_1.App.Inst.chain.web3);
            erc20.transfer(this._contract.address, value + "");
        });
    }
    depositeUSDL() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            const value = parseFloat(this.ctrls.iValue.value);
            if (!value)
                return;
            var erc20 = new ERC20Contract_1.ERC20Contract(App_1.App.Inst.chain.addressTokenUSDL, App_1.App.Inst.chain.web3);
            erc20.transfer(this._contract.address, value + "");
        });
    }
}
exports.StabilityPoolView = StabilityPoolView;
//# sourceMappingURL=StabilityPoolView.js.map

/***/ }),

/***/ "./bin/classes/com/contractViews/UPTokenView.js":
/*!******************************************************!*\
  !*** ./bin/classes/com/contractViews/UPTokenView.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UPTokenView = void 0;
const com = __webpack_require__(/*! ../tmpls */ "./bin/classes/com/tmpls.js");
const App_1 = __webpack_require__(/*! ../../App */ "./bin/classes/App.js");
class UPTokenView extends com.CmpBlockUpToken {
    constructor(contract, burnable) {
        super();
        this._contract = contract;
        this._burnable = burnable;
        this.ctrls.btnBurn.onclick = () => this.tryBurn();
        this.ctrls.btnRefresh.onclick = () => this.refresh();
        let inputPhonePrevValue = '';
        let iBurnInput = this.ctrls.iBurnValue.el;
        iBurnInput.addEventListener("input", (e) => {
            if (iBurnInput.value && !new RegExp(/^\d$|^\d+(\.\d+)?$|^\d+(\.)?$/).test(iBurnInput.value)) {
                iBurnInput.value = inputPhonePrevValue;
                return;
            }
            inputPhonePrevValue = iBurnInput.value;
        });
    }
    refresh() {
        return __awaiter(this, void 0, void 0, function* () {
            this.ctrls.btnRefresh.disable();
            const initSupply = 51869006448.8;
            const total = yield this._contract.totalSupply();
            this.ctrls.btnRefresh.enable();
            const burned = (initSupply - parseFloat(total)) + "";
            this.ctrls.lTotal.html = `Remaining Supply: <span>${App_1.App.Inst.chain.ethToFormat(total + "")}</span>`;
            this.ctrls.lBurned.html = `Burned: <span>${App_1.App.Inst.chain.ethToFormat(burned + "")}</span>`;
        });
    }
    tryBurn() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            const value = parseFloat(this.ctrls.iBurnValue.value);
            if (!value)
                return;
            this._burnable.burn(value + "");
        });
    }
}
exports.UPTokenView = UPTokenView;
//# sourceMappingURL=UPTokenView.js.map

/***/ }),

/***/ "./bin/classes/com/contractViews/UpManagerView.js":
/*!********************************************************!*\
  !*** ./bin/classes/com/contractViews/UpManagerView.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpManagerView = void 0;
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const com = __webpack_require__(/*! ../tmpls */ "./bin/classes/com/tmpls.js");
const App_1 = __webpack_require__(/*! ../../App */ "./bin/classes/App.js");
class UpManagerView extends com.CmpBlockUpManager {
    constructor(contract) {
        super();
        this._contract = contract;
        this.ctrls.btnUpdate.onclick = () => this.update();
        this.ctrls.btnUpdateSelectively.onclick = () => this.updateSel();
        this.ctrls.btnUpdate.disable();
        this.ctrls.btnUpdateSelectively.disable();
        this._fastRefresh();
        this.ctrls.btnAdditional.onclick = () => {
            this._showAdditionalAsync();
        };
    }
    _fastRefresh() {
        return __awaiter(this, void 0, void 0, function* () {
            this.ctrls.lAddress.text = this._contract.address;
            const started = yield this._contract.getStarted();
            if (started)
                this.ctrls.lState.text = "State: Working";
            else
                this.ctrls.lState.text = "Not started";
            this.ctrls.btnUpdate.enable();
            const needUpdate = yield this._contract.needUpdate();
            if (needUpdate) {
                this.ctrls.btnUpdateSelectively.enable();
            }
            else {
                this.ctrls.btnUpdateSelectively.disable();
            }
        });
    }
    _showAdditionalAsync() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.ctrls.blockAdditional.hasClass('d-none')) {
                this.ctrls.blockAdditional.hide();
                return;
            }
            this.ctrls.blockAdditional.show();
            this.ctrls.lTokenUP.text = yield this._contract.getTokenUP();
            this.ctrls.lTokenUSDL.text = yield this._contract.getTokenUSDL();
            this.ctrls.lTokenLOAN.text = yield this._contract.getTokenLOAN();
            this.ctrls.lLLVaultManager.text = yield this._contract.getLLVaultManager();
            this.ctrls.lLLBorrower.text = yield this._contract.getLLBorrower();
            this.ctrls.lLLStakePool.text = yield this._contract.getLLStakePool();
            this.ctrls.lLLStabilityPool.text = yield this._contract.getLLStabilityPool();
            //this.ctrls.lLLHintHelpers.text = await this._contract.getLLHintHelpers();
            const started = yield this._contract.getStarted();
            this.ctrls.lTradeBot.text = yield this._contract.getTradeBot();
            this.ctrls.lDelegatedSwapper.text = yield this._contract.getDelegatedSwapper();
            this.ctrls.lRewardPool.text = yield this._contract.getRewardPool();
            this.ctrls.lPriceKeeperUP.text = yield this._contract.getPriceKeeperUP();
            this.ctrls.lPriceKeeperPLS.text = yield this._contract.getPriceKeeperPLS();
            this.ctrls.lBuyBurnPool.text = yield this._contract.getBuyBurnPool();
            this.ctrls.lStabilityPool.text = yield this._contract.getStabilityPool();
            this.ctrls.lInternalExchangerBnB.text = yield this._contract.getInternalExchangerBnB();
            this.ctrls.lInternalExchangerSP.text = yield this._contract.getInternalExchangerSP();
            this.ctrls.lLiquidControllersDeployer.text = yield this._contract.getLiquidControllersDeployer();
            if (started) {
                let vaultInfo = [];
                let index = 0;
                for (const v of App_1.App.Inst.chain.liquidControllers) {
                    vaultInfo.push(index + ": " + v.address);
                    index++;
                }
                this.ctrls.lVaults.html = '<br>' + vaultInfo.join('<br>');
            }
            this.ctrls.lBalance.text = yield this._contract.getBalance();
        });
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            yield App_1.App.Inst.chain.getAccountAsync();
            yield this._contract.update();
        });
    }
    updateSel() {
        return __awaiter(this, void 0, void 0, function* () {
            this.ctrls.btnUpdateSelectively.disable();
            try {
                yield App_1.App.Inst.chain.getAccountAsync();
                let bnbPool = yield App_1.App.Inst.chain.buyBurnPool.needUpdate();
                if (bnbPool)
                    bnbPool = yield App_1.App.Inst.chain.buyBurnPool.checkUpdateWorkable();
                let sPool = yield App_1.App.Inst.chain.stabilityPool.needUpdate();
                if (sPool)
                    sPool = yield App_1.App.Inst.chain.stabilityPool.checkUpdateWorkable();
                let lcs = [];
                let index = 0;
                let needLCSUpdate = false;
                for (const v of App_1.App.Inst.chain.liquidControllers) {
                    let needUpdate = yield v.needUpdate();
                    if (needUpdate)
                        needUpdate = yield v.checkUpdateWorkable();
                    if (needUpdate)
                        lcs.push(index);
                    index++;
                }
                if (!sPool && !bnbPool && lcs.length == 0) {
                    new modalCom.DialogOk("No need to update", "Attention").show();
                    return;
                }
                yield this._contract.updateSelectively(bnbPool, sPool, lcs);
            }
            catch (e) {
                this.ctrls.btnUpdateSelectively.enable();
                throw e;
            }
            this.ctrls.btnUpdateSelectively.enable();
        });
    }
}
exports.UpManagerView = UpManagerView;
//# sourceMappingURL=UpManagerView.js.map

/***/ }),

/***/ "./bin/classes/com/tmpls.js":
/*!**********************************!*\
  !*** ./bin/classes/com/tmpls.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CmpShareX = exports.CmpUpVaultController = exports.CmpStabilityPool = exports.CmpBuyBurnPool = exports.CmpInternalExchanger = exports.CmpPriceKeeper = exports.CmpBlockContracts = exports.CmpBlockChart = exports.CmpBlockPools = exports.CmpBlockInternalExchangers = exports.CmpStatsItem = exports.CmpBlockStatsContainer = exports.CmpBlockUpManager = exports.CmpBlockUpToken = exports.CmpBlockPriceKeepers = exports.PageDashboard = exports.PageLoading = exports.TopNavBar = exports.ModalDialog = void 0;
const gs = __webpack_require__(/*! @ivanlog/gs */ "./node_modules/@ivanlog/gs/index.js");
class ModalDialogControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.container = this._ctrls.get('container');
        this.content = this._ctrls.get('content');
        this.header = this._ctrls.get('header');
        this.textTitle = this._ctrls.get('textTitle');
        this.btnClose = this._ctrls.get('btnClose');
        this.body = this._ctrls.get('body');
        this.footer = this._ctrls.get('footer');
        this.btnOk = this._ctrls.get('btnOk');
        this.btnNo = this._ctrls.get('btnNo');
        this.btnCancel = this._ctrls.get('btnCancel');
    }
}
class ModalDialog extends gs.ComponentGS {
    constructor() {
        super("modalDialog", ModalDialogControls);
    }
}
exports.ModalDialog = ModalDialog;
class TopNavBarControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.label = this._ctrls.get('label');
    }
}
class TopNavBar extends gs.ComponentGS {
    constructor() {
        super("topNavBar", TopNavBarControls);
    }
}
exports.TopNavBar = TopNavBar;
class PageLoadingControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
    }
}
class PageLoading extends gs.ComponentGS {
    constructor() {
        super("pageLoading", PageLoadingControls);
    }
}
exports.PageLoading = PageLoading;
class PageDashboardControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.blocks = this._ctrls.get('blocks');
    }
}
class PageDashboard extends gs.ComponentGS {
    constructor() {
        super("pageDashboard", PageDashboardControls);
    }
}
exports.PageDashboard = PageDashboard;
class CmpBlockPriceKeepersControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.blockPrices = this._ctrls.get('blockPrices');
    }
}
class CmpBlockPriceKeepers extends gs.ComponentGS {
    constructor() {
        super("cmpBlockPriceKeepers", CmpBlockPriceKeepersControls);
    }
}
exports.CmpBlockPriceKeepers = CmpBlockPriceKeepers;
class CmpBlockUpTokenControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.btnRefresh = this._ctrls.get('btnRefresh');
        this.lTotal = this._ctrls.get('lTotal');
        this.lBurned = this._ctrls.get('lBurned');
        this.iBurnValue = this._ctrls.get('iBurnValue');
        this.btnBurn = this._ctrls.get('btnBurn');
    }
}
class CmpBlockUpToken extends gs.ComponentGS {
    constructor() {
        super("cmpBlockUpToken", CmpBlockUpTokenControls);
    }
}
exports.CmpBlockUpToken = CmpBlockUpToken;
class CmpBlockUpManagerControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.imgLogo = this._ctrls.get('imgLogo');
        this.btnUpdate = this._ctrls.get('btnUpdate');
        this.btnUpdateSelectively = this._ctrls.get('btnUpdateSelectively');
        this.btnAdditional = this._ctrls.get('btnAdditional');
        this.lState = this._ctrls.get('lState');
        this.lAddress = this._ctrls.get('lAddress');
        this.blockAdditional = this._ctrls.get('blockAdditional');
        this.lBalance = this._ctrls.get('lBalance');
        this.lTokenLOAN = this._ctrls.get('lTokenLOAN');
        this.lTokenUSDL = this._ctrls.get('lTokenUSDL');
        this.lTokenUP = this._ctrls.get('lTokenUP');
        this.lLLVaultManager = this._ctrls.get('lLLVaultManager');
        this.lLLBorrower = this._ctrls.get('lLLBorrower');
        this.lLLStakePool = this._ctrls.get('lLLStakePool');
        this.lLLStabilityPool = this._ctrls.get('lLLStabilityPool');
        this.lTradeBot = this._ctrls.get('lTradeBot');
        this.lDelegatedSwapper = this._ctrls.get('lDelegatedSwapper');
        this.lRewardPool = this._ctrls.get('lRewardPool');
        this.lPriceKeeperPLS = this._ctrls.get('lPriceKeeperPLS');
        this.lPriceKeeperUP = this._ctrls.get('lPriceKeeperUP');
        this.lBuyBurnPool = this._ctrls.get('lBuyBurnPool');
        this.lStabilityPool = this._ctrls.get('lStabilityPool');
        this.lInternalExchangerBnB = this._ctrls.get('lInternalExchangerBnB');
        this.lInternalExchangerSP = this._ctrls.get('lInternalExchangerSP');
        this.lLiquidControllersDeployer = this._ctrls.get('lLiquidControllersDeployer');
        this.lVaults = this._ctrls.get('lVaults');
    }
}
class CmpBlockUpManager extends gs.ComponentGS {
    constructor() {
        super("cmpBlockUpManager", CmpBlockUpManagerControls);
    }
}
exports.CmpBlockUpManager = CmpBlockUpManager;
class CmpBlockStatsContainerControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.blockContainer = this._ctrls.get('blockContainer');
    }
}
class CmpBlockStatsContainer extends gs.ComponentGS {
    constructor() {
        super("cmpBlockStatsContainer", CmpBlockStatsContainerControls);
    }
}
exports.CmpBlockStatsContainer = CmpBlockStatsContainer;
class CmpStatsItemControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.lHeader = this._ctrls.get('lHeader');
        this.lText = this._ctrls.get('lText');
        this.lDescription = this._ctrls.get('lDescription');
    }
}
class CmpStatsItem extends gs.ComponentGS {
    constructor() {
        super("cmpStatsItem", CmpStatsItemControls);
    }
}
exports.CmpStatsItem = CmpStatsItem;
class CmpBlockInternalExchangersControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.blockExchangers = this._ctrls.get('blockExchangers');
    }
}
class CmpBlockInternalExchangers extends gs.ComponentGS {
    constructor() {
        super("cmpBlockInternalExchangers", CmpBlockInternalExchangersControls);
    }
}
exports.CmpBlockInternalExchangers = CmpBlockInternalExchangers;
class CmpBlockPoolsControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.blockPools = this._ctrls.get('blockPools');
    }
}
class CmpBlockPools extends gs.ComponentGS {
    constructor() {
        super("cmpBlockPools", CmpBlockPoolsControls);
    }
}
exports.CmpBlockPools = CmpBlockPools;
class CmpBlockChartControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.blockChart = this._ctrls.get('blockChart');
    }
}
class CmpBlockChart extends gs.ComponentGS {
    constructor() {
        super("cmpBlockChart", CmpBlockChartControls);
    }
}
exports.CmpBlockChart = CmpBlockChart;
class CmpBlockContractsControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.blockContainer = this._ctrls.get('blockContainer');
    }
}
class CmpBlockContracts extends gs.ComponentGS {
    constructor() {
        super("cmpBlockContracts", CmpBlockContractsControls);
    }
}
exports.CmpBlockContracts = CmpBlockContracts;
class CmpPriceKeeperControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.btnRefresh = this._ctrls.get('btnRefresh');
        this.btnInfo = this._ctrls.get('btnInfo');
        this.lFaqInfo = this._ctrls.get('lFaqInfo');
        this.lToken = this._ctrls.get('lToken');
        this.lPrice = this._ctrls.get('lPrice');
        this.lTokenAddress = this._ctrls.get('lTokenAddress');
    }
}
class CmpPriceKeeper extends gs.ComponentGS {
    constructor() {
        super("cmpPriceKeeper", CmpPriceKeeperControls);
    }
}
exports.CmpPriceKeeper = CmpPriceKeeper;
class CmpInternalExchangerControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.btnRefresh = this._ctrls.get('btnRefresh');
        this.btnInfo = this._ctrls.get('btnInfo');
        this.lFaqInfo = this._ctrls.get('lFaqInfo');
        this.lName = this._ctrls.get('lName');
        this.lBalancePLS = this._ctrls.get('lBalancePLS');
    }
}
class CmpInternalExchanger extends gs.ComponentGS {
    constructor() {
        super("cmpInternalExchanger", CmpInternalExchangerControls);
    }
}
exports.CmpInternalExchanger = CmpInternalExchanger;
class CmpBuyBurnPoolControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.btnRefresh = this._ctrls.get('btnRefresh');
        this.btnInfo = this._ctrls.get('btnInfo');
        this.lFaqInfo = this._ctrls.get('lFaqInfo');
        this.lBalancePLS = this._ctrls.get('lBalancePLS');
        this.lBalanceUSDL = this._ctrls.get('lBalanceUSDL');
        this.lBalanceLOAN = this._ctrls.get('lBalanceLOAN');
        this.lStakedUSDL = this._ctrls.get('lStakedUSDL');
        this.lStakedLOAN = this._ctrls.get('lStakedLOAN');
        this.lStabilityRewardLOAN = this._ctrls.get('lStabilityRewardLOAN');
        this.lStabilityRewardPLS = this._ctrls.get('lStabilityRewardPLS');
        this.lStakeRewardUSDL = this._ctrls.get('lStakeRewardUSDL');
        this.lStakeRewardPLS = this._ctrls.get('lStakeRewardPLS');
        this.lPriceATH = this._ctrls.get('lPriceATH');
        this.lForSwapUSDL = this._ctrls.get('lForSwapUSDL');
        this.lLastUpdateTime = this._ctrls.get('lLastUpdateTime');
        this.lPreBnBSeqTime = this._ctrls.get('lPreBnBSeqTime');
        this.lBotPriority = this._ctrls.get('lBotPriority');
        this.iValue = this._ctrls.get('iValue');
        this.btnDepositeUSDL = this._ctrls.get('btnDepositeUSDL');
        this.iValueLOAN = this._ctrls.get('iValueLOAN');
        this.btnDepositeLOAN = this._ctrls.get('btnDepositeLOAN');
        this.iValueUP = this._ctrls.get('iValueUP');
        this.btnDepositeUP = this._ctrls.get('btnDepositeUP');
        this.btnUpdate = this._ctrls.get('btnUpdate');
    }
}
class CmpBuyBurnPool extends gs.ComponentGS {
    constructor() {
        super("cmpBuyBurnPool", CmpBuyBurnPoolControls);
    }
}
exports.CmpBuyBurnPool = CmpBuyBurnPool;
class CmpStabilityPoolControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.btnRefresh = this._ctrls.get('btnRefresh');
        this.btnInfo = this._ctrls.get('btnInfo');
        this.lFaqInfo = this._ctrls.get('lFaqInfo');
        this.lBalancePLS = this._ctrls.get('lBalancePLS');
        this.lBalanceUSDL = this._ctrls.get('lBalanceUSDL');
        this.lBalanceLOAN = this._ctrls.get('lBalanceLOAN');
        this.lStakedUSDL = this._ctrls.get('lStakedUSDL');
        this.lStakedLOAN = this._ctrls.get('lStakedLOAN');
        this.lStabilityRewardLOAN = this._ctrls.get('lStabilityRewardLOAN');
        this.lStabilityRewardPLS = this._ctrls.get('lStabilityRewardPLS');
        this.lStakeRewardUSDL = this._ctrls.get('lStakeRewardUSDL');
        this.lStakeRewardPLS = this._ctrls.get('lStakeRewardPLS');
        this.lPricePLS_ATH = this._ctrls.get('lPricePLS_ATH');
        this.lInSwapMode = this._ctrls.get('lInSwapMode');
        this.lLastUpdateTime = this._ctrls.get('lLastUpdateTime');
        this.iValue = this._ctrls.get('iValue');
        this.btnDepositeUSDL = this._ctrls.get('btnDepositeUSDL');
        this.iValueLOAN = this._ctrls.get('iValueLOAN');
        this.btnDepositeLOAN = this._ctrls.get('btnDepositeLOAN');
        this.btnUpdate = this._ctrls.get('btnUpdate');
    }
}
class CmpStabilityPool extends gs.ComponentGS {
    constructor() {
        super("cmpStabilityPool", CmpStabilityPoolControls);
    }
}
exports.CmpStabilityPool = CmpStabilityPool;
class CmpUpVaultControllerControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.btnRefresh = this._ctrls.get('btnRefresh');
        this.btnInfo = this._ctrls.get('btnInfo');
        this.lFaqInfo = this._ctrls.get('lFaqInfo');
        this.lLabel = this._ctrls.get('lLabel');
        this.lStatus = this._ctrls.get('lStatus');
        this.lBalance = this._ctrls.get('lBalance');
        this.lBalanceUSDL = this._ctrls.get('lBalanceUSDL');
        this.lICR = this._ctrls.get('lICR');
        this.lDebt = this._ctrls.get('lDebt');
        this.lColl = this._ctrls.get('lColl');
        this.lTargetICR = this._ctrls.get('lTargetICR');
        this.lTargetReloanICR = this._ctrls.get('lTargetReloanICR');
        this.lllMinLoan = this._ctrls.get('lllMinLoan');
        this.lllGas = this._ctrls.get('lllGas');
        this.lLoanMinReTakeUSDL = this._ctrls.get('lLoanMinReTakeUSDL');
        this.lSwapMinUSDL = this._ctrls.get('lSwapMinUSDL');
        this.lMaxLoanDumpIndex = this._ctrls.get('lMaxLoanDumpIndex');
        this.lStabPoolSplitPartRever = this._ctrls.get('lStabPoolSplitPartRever');
        this.lBuyBurnSplitPartRevers = this._ctrls.get('lBuyBurnSplitPartRevers');
        this.iValueUSDL = this._ctrls.get('iValueUSDL');
        this.btnDepositeUSDL = this._ctrls.get('btnDepositeUSDL');
        this.iValuePLS = this._ctrls.get('iValuePLS');
        this.btnDepositePLS = this._ctrls.get('btnDepositePLS');
        this.btnUpdate = this._ctrls.get('btnUpdate');
    }
}
class CmpUpVaultController extends gs.ComponentGS {
    constructor() {
        super("cmpUpVaultController", CmpUpVaultControllerControls);
    }
}
exports.CmpUpVaultController = CmpUpVaultController;
class CmpShareXControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.btnRefresh = this._ctrls.get('btnRefresh');
        this.btnInfo = this._ctrls.get('btnInfo');
        this.lFaqInfo = this._ctrls.get('lFaqInfo');
        this.lName = this._ctrls.get('lName');
        this.lTotalSupply = this._ctrls.get('lTotalSupply');
        this.lBalancePLS = this._ctrls.get('lBalancePLS');
        this.lBalanceUSDL = this._ctrls.get('lBalanceUSDL');
        this.lNeedConsumePLS = this._ctrls.get('lNeedConsumePLS');
        this.lNeedConsumeUSDL = this._ctrls.get('lNeedConsumeUSDL');
        this.lShare = this._ctrls.get('lShare');
        this.lRewardPLS = this._ctrls.get('lRewardPLS');
        this.lRewardUSDL = this._ctrls.get('lRewardUSDL');
        this.iValueUSDL = this._ctrls.get('iValueUSDL');
        this.btnDepositeUSDL = this._ctrls.get('btnDepositeUSDL');
        this.iValuePLS = this._ctrls.get('iValuePLS');
        this.btnDepositePLS = this._ctrls.get('btnDepositePLS');
        this.btnConsumePLS = this._ctrls.get('btnConsumePLS');
        this.btnConsumeUSDL = this._ctrls.get('btnConsumeUSDL');
        this.btnWithdrawPLS = this._ctrls.get('btnWithdrawPLS');
        this.btnWithdrawUSDL = this._ctrls.get('btnWithdrawUSDL');
    }
}
class CmpShareX extends gs.ComponentGS {
    constructor() {
        super("cmpShareX", CmpShareXControls);
    }
}
exports.CmpShareX = CmpShareX;
gs.WrapperGS.InjectComponents(ModalDialog, 'ModalDialog');
gs.WrapperGS.InjectComponents(TopNavBar, 'TopNavBar');
gs.WrapperGS.InjectComponents(PageLoading, 'PageLoading');
gs.WrapperGS.InjectComponents(PageDashboard, 'PageDashboard');
gs.WrapperGS.InjectComponents(CmpBlockPriceKeepers, 'CmpBlockPriceKeepers');
gs.WrapperGS.InjectComponents(CmpBlockUpToken, 'CmpBlockUpToken');
gs.WrapperGS.InjectComponents(CmpBlockUpManager, 'CmpBlockUpManager');
gs.WrapperGS.InjectComponents(CmpBlockStatsContainer, 'CmpBlockStatsContainer');
gs.WrapperGS.InjectComponents(CmpStatsItem, 'CmpStatsItem');
gs.WrapperGS.InjectComponents(CmpBlockInternalExchangers, 'CmpBlockInternalExchangers');
gs.WrapperGS.InjectComponents(CmpBlockPools, 'CmpBlockPools');
gs.WrapperGS.InjectComponents(CmpBlockChart, 'CmpBlockChart');
gs.WrapperGS.InjectComponents(CmpBlockContracts, 'CmpBlockContracts');
gs.WrapperGS.InjectComponents(CmpPriceKeeper, 'CmpPriceKeeper');
gs.WrapperGS.InjectComponents(CmpInternalExchanger, 'CmpInternalExchanger');
gs.WrapperGS.InjectComponents(CmpBuyBurnPool, 'CmpBuyBurnPool');
gs.WrapperGS.InjectComponents(CmpStabilityPool, 'CmpStabilityPool');
gs.WrapperGS.InjectComponents(CmpUpVaultController, 'CmpUpVaultController');
gs.WrapperGS.InjectComponents(CmpShareX, 'CmpShareX');
//# sourceMappingURL=tmpls.js.map

/***/ }),

/***/ "./bin/classes/contracts/BurnableContract.js":
/*!***************************************************!*\
  !*** ./bin/classes/contracts/BurnableContract.js ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BurnableContract = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const BurnableABI_1 = __webpack_require__(/*! ./abi/BurnableABI */ "./bin/classes/contracts/abi/BurnableABI.js");
class BurnableContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, BurnableABI_1.BurnableABI.GetABI());
    }
    burn(valueEth) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield this._send('burn', this._web3.utils.toWei(valueEth, "ether"));
        });
    }
}
exports.BurnableContract = BurnableContract;
//# sourceMappingURL=BurnableContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/BuyBurnPoolContract.js":
/*!******************************************************!*\
  !*** ./bin/classes/contracts/BuyBurnPoolContract.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BuyBurnPoolContract = exports.BuyBurnPoolContractStatisticStruct = void 0;
const BuyBurnPoolABI_1 = __webpack_require__(/*! ./abi/BuyBurnPoolABI */ "./bin/classes/contracts/abi/BuyBurnPoolABI.js");
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const App_1 = __webpack_require__(/*! ../App */ "./bin/classes/App.js");
class BuyBurnPoolContractStatisticStruct {
}
exports.BuyBurnPoolContractStatisticStruct = BuyBurnPoolContractStatisticStruct;
class BuyBurnPoolContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, BuyBurnPoolABI_1.BuyBurnPoolABI.GetABI());
    }
    getPriceATH() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("priceATH"); return this._toEther(value); });
    }
    getLastUpdateTimestamp() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("lastUpdateTimestamp"); });
    }
    getForSwapUSDL() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("forSwapUSDL"); return this._toEther(value); });
    }
    getPreBnBSeqTimestamp() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("preBnBSeqTimestamp"); });
    }
    getBotPriority() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("botPriority"); });
    }
    getStatistics() {
        return __awaiter(this, void 0, void 0, function* () {
            const respose = yield this._call("statistics");
            if (!respose)
                return respose;
            respose.lastBoughtAmountUSDL = this._toEther(respose.lastBoughtAmountUSDL);
            respose.totalBoughtAmountUSDL = this._toEther(respose.totalBoughtAmountUSDL);
            respose.totalBurnUp = this._toEther(respose.totalBurnUp);
            return respose;
        });
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("update"); });
    }
    needUpdate() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._callInSilence("needUpdate"); });
    }
    checkUpdateWorkable() {
        return __awaiter(this, void 0, void 0, function* () {
            var account = yield App_1.App.Inst.chain.getAccountAsync();
            try {
                let gas = yield this._contract.methods["update"]().estimateGas({ from: account });
                return true;
            }
            catch (e) {
                return false;
            }
        });
    }
    getBalance() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalance");
            return this._toEther(res);
        });
    }
    getBalanceToken(address) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalanceToken", address);
            return this._toEther(res);
        });
    }
    getStakedUSDL() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getStakedUSDL"); return this._toEther(value); });
    }
    getStakedLOAN() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getStakedLOAN"); return this._toEther(value); });
    }
    getPendingGainForUSDL() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getPendingGainForUSDL"); return { loan: this._toEther(value.loan + ""), pls: this._toEther(value.pls + "") }; });
    }
    getPendingGainForLOAN() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getPendingGainForLOAN"); return { usdl: this._toEther(value.usdl + ""), pls: this._toEther(value.pls + "") }; });
    }
}
exports.BuyBurnPoolContract = BuyBurnPoolContract;
//# sourceMappingURL=BuyBurnPoolContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/ERC20Contract.js":
/*!************************************************!*\
  !*** ./bin/classes/contracts/ERC20Contract.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ERC20Contract = void 0;
const ERC20ABI_1 = __webpack_require__(/*! ./abi/ERC20ABI */ "./bin/classes/contracts/abi/ERC20ABI.js");
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
class ERC20Contract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, ERC20ABI_1.ERC20ABI.GetABI());
    }
    name() {
        return __awaiter(this, void 0, void 0, function* () {
            return this._call("name");
        });
    }
    symbol() {
        return __awaiter(this, void 0, void 0, function* () {
            return this._call("symbol");
        });
    }
    totalSupply() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("totalSupply");
            return this._toEther(res);
        });
    }
    transfer(to, amountEth) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield this._send('transfer', to, this._web3.utils.toWei(amountEth, "ether"));
        });
    }
    balanceOf(address) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("balanceOf", address);
            return this._toEther(res);
        });
    }
}
exports.ERC20Contract = ERC20Contract;
//# sourceMappingURL=ERC20Contract.js.map

/***/ }),

/***/ "./bin/classes/contracts/InternalExchangerBnBContract.js":
/*!***************************************************************!*\
  !*** ./bin/classes/contracts/InternalExchangerBnBContract.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InternalExchangerBnBContract = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const InternalExchangerBnBABI_1 = __webpack_require__(/*! ./abi/InternalExchangerBnBABI */ "./bin/classes/contracts/abi/InternalExchangerBnBABI.js");
class InternalExchangerBnBContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, InternalExchangerBnBABI_1.InternalExchangerBnBABI.GetABI());
    }
    getBalance() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this.web3.eth.getBalance(this.address);
            return this._toEther(res);
        });
    }
}
exports.InternalExchangerBnBContract = InternalExchangerBnBContract;
//# sourceMappingURL=InternalExchangerBnBContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/InternalExchangerSPContract.js":
/*!**************************************************************!*\
  !*** ./bin/classes/contracts/InternalExchangerSPContract.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InternalExchangerSPContract = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const InternalExchangerSPABI_1 = __webpack_require__(/*! ./abi/InternalExchangerSPABI */ "./bin/classes/contracts/abi/InternalExchangerSPABI.js");
class InternalExchangerSPContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, InternalExchangerSPABI_1.InternalExchangerSPABI.GetABI());
    }
    getBalance() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this.web3.eth.getBalance(this.address);
            return this._toEther(res);
        });
    }
}
exports.InternalExchangerSPContract = InternalExchangerSPContract;
//# sourceMappingURL=InternalExchangerSPContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/LiquidControllerContract.js":
/*!***********************************************************!*\
  !*** ./bin/classes/contracts/LiquidControllerContract.js ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LiquidControllerContract = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const LiquidControllerABI_1 = __webpack_require__(/*! ./abi/LiquidControllerABI */ "./bin/classes/contracts/abi/LiquidControllerABI.js");
const App_1 = __webpack_require__(/*! ../App */ "./bin/classes/App.js");
class LiquidControllerContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3, id) {
        super(address, web3, LiquidControllerABI_1.LiquidControllerABI.GetABI());
        this.id = id;
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("update"); });
    }
    needUpdate() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._callInSilence("needUpdate"); });
    }
    checkUpdateWorkable() {
        return __awaiter(this, void 0, void 0, function* () {
            var account = yield App_1.App.Inst.chain.getAccountAsync();
            try {
                let gas = yield this._contract.methods["update"]().estimateGas({ from: account });
                return true;
            }
            catch (e) {
                return false;
            }
        });
    }
    getBalance() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalance");
            return this._toEther(res);
        });
    }
    getBalanceToken(address) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalanceToken", address);
            return this._toEther(res);
        });
    }
    deposit(value) {
        return __awaiter(this, void 0, void 0, function* () {
            const wei = this._toWei(value);
            const res = yield this._pay(wei, "deposit");
            return res;
        });
    }
    // async setMaxSwapDumpIndex(dumpIndex:Number)
    // {
    //     const wei  =this._toWei(dumpIndex+"");
    //     const res = this._send("setMaxSwapDumpIndex", wei);       
    //     return res;
    // }
    getStatus() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("getStatus"); });
    }
    getICR() {
        return __awaiter(this, void 0, void 0, function* () { return this._toEther(yield this._call("getICR")); });
    }
    getDebt() {
        return __awaiter(this, void 0, void 0, function* () { return this._toEther(yield this._call("getDebt")); });
    }
    getColl() {
        return __awaiter(this, void 0, void 0, function* () { return this._toEther(yield this._call("getColl")); });
    }
    getConfig() {
        return __awaiter(this, void 0, void 0, function* () {
            const obj = yield this._call("getConfig");
            return {
                llMinLoan: this._toEther(obj._llMinLoan + ""),
                llGas: this._toEther(obj._llGas + ""),
                loanMinReTakeUSDL: this._toEther(obj._loanMinReTakeUSDL + ""),
                swapMinUSDL: this._toEther(obj._swapMinUSDL + ""),
                maxLoanDumpIndex: this._toEther(obj._maxLoanDumpIndex + ""),
                targetICR: this._toEther(obj._targetICR + ""),
                targetReloanICR: this._toEther(obj._targetReloanICR + ""),
                stabPoolSplitPartRevers: obj._stabPoolSplitPartRevers + "",
                buyBurnSplitPartRevers: obj._buyBurnSplitPartRevers + ""
            };
        });
    }
}
exports.LiquidControllerContract = LiquidControllerContract;
//# sourceMappingURL=LiquidControllerContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/PriceKeeperContract.js":
/*!******************************************************!*\
  !*** ./bin/classes/contracts/PriceKeeperContract.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PriceKeeperContract = void 0;
const PriceKeeperABI_1 = __webpack_require__(/*! ./abi/PriceKeeperABI */ "./bin/classes/contracts/abi/PriceKeeperABI.js");
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
class PriceKeeperContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, PriceKeeperABI_1.PriceKeeperABI.GetABI());
    }
    getPrice() {
        return __awaiter(this, void 0, void 0, function* () {
            return this._toEther(yield this._call("getPrice", "1000000000000000000"));
        });
    }
    getCorrectionIndex() {
        return __awaiter(this, void 0, void 0, function* () {
            return this._toEther(yield this._call("getCorrectionIndex"));
        });
    }
    setCorrectionIndex(corIndex) {
        return __awaiter(this, void 0, void 0, function* () {
            const wei = this._toWei(corIndex + "");
            const res = this._send("setCorrectionIndex", wei);
            return res;
        });
    }
    getQuoteToken() {
        return __awaiter(this, void 0, void 0, function* () {
            return this._call("getQuoteToken");
        });
    }
}
exports.PriceKeeperContract = PriceKeeperContract;
//# sourceMappingURL=PriceKeeperContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/ShareXContract.js":
/*!*************************************************!*\
  !*** ./bin/classes/contracts/ShareXContract.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ShareXContract = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const ShareXABI_1 = __webpack_require__(/*! ./abi/ShareXABI */ "./bin/classes/contracts/abi/ShareXABI.js");
class ShareXContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, ShareXABI_1.ShareXABI.GetABI());
    }
    deposite(value) {
        return __awaiter(this, void 0, void 0, function* () {
            const wei = this._toWei(value);
            const res = yield this._pay(wei, "deposite");
            return res;
        });
    }
    name() {
        return __awaiter(this, void 0, void 0, function* () {
            return this._call("name");
        });
    }
    symbol() {
        return __awaiter(this, void 0, void 0, function* () {
            return this._call("symbol");
        });
    }
    totalSupply() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("totalSupply");
            return res;
        });
    }
    transfer(to, amountEth) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield this._send('transfer', to, this._web3.utils.toWei(amountEth, "ether"));
        });
    }
    balanceOf(address) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("balanceOf", address);
            return res;
        });
    }
    getBalance() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalance");
            return this._toEther(res);
        });
    }
    getBalanceToken(address) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalanceToken", address);
            return this._toEther(res);
        });
    }
    getConsumedBalance(address) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getConsumedBalance", address);
            return this._toEther(res);
        });
    }
    getConsumedBalanceETH() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getConsumedBalanceETH");
            return this._toEther(res);
        });
    }
    getCost(address) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getCost", address);
            return this._toEther(res);
        });
    }
    getCostETH() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getCostETH");
            return this._toEther(res);
        });
    }
    getShareCost(shareAddress, tokenAddress) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getShareCost", shareAddress, tokenAddress);
            return this._toEther(res);
        });
    }
    getShareCostETH(shareAddress) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getShareCostETH", shareAddress);
            return this._toEther(res);
        });
    }
    consumeIncomeETH() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("consumeIncomeETH"); });
    }
    consumeIncomeERC20(address) {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("consumeIncomeERC20", address); });
    }
    withdrawETH() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("withdrawETH"); });
    }
    withdrawERC20(address) {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("withdrawERC20", address); });
    }
}
exports.ShareXContract = ShareXContract;
//# sourceMappingURL=ShareXContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/StabilityPoolContract.js":
/*!********************************************************!*\
  !*** ./bin/classes/contracts/StabilityPoolContract.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StabilityPoolContract = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const StabilityPoolABI_1 = __webpack_require__(/*! ./abi/StabilityPoolABI */ "./bin/classes/contracts/abi/StabilityPoolABI.js");
const App_1 = __webpack_require__(/*! ../App */ "./bin/classes/App.js");
class StabilityPoolContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, StabilityPoolABI_1.StabilityPoolABI.GetABI());
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("update"); });
    }
    needUpdate() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._callInSilence("needUpdate"); });
    }
    checkUpdateWorkable() {
        return __awaiter(this, void 0, void 0, function* () {
            var account = yield App_1.App.Inst.chain.getAccountAsync();
            try {
                let gas = yield this._contract.methods["update"]().estimateGas({ from: account });
                return true;
            }
            catch (e) {
                return false;
            }
        });
    }
    getBalance() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalance");
            return this._toEther(res);
        });
    }
    getBalanceToken(address) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalanceToken", address);
            return this._toEther(res);
        });
    }
    getPricePLS_ATH() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("pricePLS_ATH"); return this._toEther(value); });
    }
    getPricePLStoSwap() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getPricePLStoSwap"); return this._toEther(value); });
    }
    getLastUpdateTimestamp() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("lastUpdateTimestamp"); });
    }
    getInSwapMode() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("inSwapMode"); });
    }
    getStakedUSDL() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getStakedUSDL"); return this._toEther(value); });
    }
    getStakedLOAN() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getStakedLOAN"); return this._toEther(value); });
    }
    getPendingGainForUSDL() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getPendingGainForUSDL"); return { loan: this._toEther(value.loan + ""), pls: this._toEther(value.pls + "") }; });
    }
    getPendingGainForLOAN() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("getPendingGainForLOAN"); return { usdl: this._toEther(value.usdl + ""), pls: this._toEther(value.pls + "") }; });
    }
}
exports.StabilityPoolContract = StabilityPoolContract;
//# sourceMappingURL=StabilityPoolContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/UpManagerContract.js":
/*!****************************************************!*\
  !*** ./bin/classes/contracts/UpManagerContract.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpManagerContract = void 0;
const UpManagerABI_1 = __webpack_require__(/*! ./abi/UpManagerABI */ "./bin/classes/contracts/abi/UpManagerABI.js");
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
class UpManagerContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, UpManagerABI_1.UpManagerABI.GetABI());
    }
    start(value) {
        return __awaiter(this, void 0, void 0, function* () {
            const wei = this._toWei(value);
            const res = yield this._pay(wei, "start");
            return res;
        });
    }
    deposit(value) {
        return __awaiter(this, void 0, void 0, function* () {
            const wei = this._toWei(value);
            const res = yield this._pay(wei, "deposit");
            return res;
        });
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("update"); });
    }
    needUpdate() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._callInSilence("needUpdate"); });
    }
    getLiquidController(index) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getLiquidController", index + "");
            if (res.count)
                res.count = parseInt(res.count);
            return res;
        });
    }
    updateSelectively(bbPool, sPool, lcsIndexes) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this._send("updateSelectively", bbPool, sPool, lcsIndexes);
        });
    }
    getStarted() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("started"); });
    }
    getBalance() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalance");
            return this._toEther(res);
        });
    }
    getBuyBurnPool() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("buyBurnPool"); });
    }
    getStabilityPool() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("stabilityPool"); });
    }
    getInternalExchangerBnB() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("internalExchangerBnB"); });
    }
    getInternalExchangerSP() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("internalExchangerSP"); });
    }
    getLiquidControllersDeployer() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("liquidControllersDeployer"); });
    }
    getLLVaultManager() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("llVaultManager"); });
    }
    getLLBorrower() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("llBorrower"); });
    }
    getLLStakePool() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("llStakePool"); });
    }
    getLLStabilityPool() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("llStabilityPool"); });
    }
    getLLHintHelpers() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("llHintHelpers"); });
    }
    getTradeBot() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("tradeBot"); });
    }
    getDelegatedSwapper() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("delegatedSwapper"); });
    }
    getRewardPool() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("rewardPool"); });
    }
    getPriceKeeperPLS() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("priceKeeperPLS"); });
    }
    getPriceKeeperUP() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("priceKeeperUP"); });
    }
    //async getWPLSToken():Promise<string> { return await this._call("tokenLOAN"); }
    getTokenLOAN() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("tokenLOAN"); });
    }
    getTokenUP() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("tokenUP"); });
    }
    getTokenUSDL() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("tokenUSDL"); });
    }
}
exports.UpManagerContract = UpManagerContract;
//# sourceMappingURL=UpManagerContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/ValidatorBnBContract.js":
/*!*******************************************************!*\
  !*** ./bin/classes/contracts/ValidatorBnBContract.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValidatorBnBContract = exports.ValidatorBnBStat = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const ValidatorBnBABI_1 = __webpack_require__(/*! ./abi/ValidatorBnBABI */ "./bin/classes/contracts/abi/ValidatorBnBABI.js");
class ValidatorBnBStat {
}
exports.ValidatorBnBStat = ValidatorBnBStat;
class ValidatorBnBContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, ValidatorBnBABI_1.ValidatorBnBABI.GetABI());
    }
    getStatistic() {
        return __awaiter(this, void 0, void 0, function* () {
            const value = yield this._call("statistics");
            const result = new ValidatorBnBStat();
            result.lastSwapTimestamp = value.lastSwapTimestamp;
            result.lastSwapAmountPLS = this._toEther(value.lastSwapAmountPLS);
            result.totalSwapAmountPLS = this._toEther(value.totalSwapAmountPLS);
            result.totalBurnUp = this._toEther(value.totalBurnUp);
            return result;
        });
    }
}
exports.ValidatorBnBContract = ValidatorBnBContract;
//# sourceMappingURL=ValidatorBnBContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/ValidatorFeeReceiverContract.js":
/*!***************************************************************!*\
  !*** ./bin/classes/contracts/ValidatorFeeReceiverContract.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValidatorFeeReceiverContract = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const ValidatorFeeReceiverABI_1 = __webpack_require__(/*! ./abi/ValidatorFeeReceiverABI */ "./bin/classes/contracts/abi/ValidatorFeeReceiverABI.js");
class ValidatorFeeReceiverContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, ValidatorFeeReceiverABI_1.ValidatorFeeReceiverABI.GetABI());
    }
    getToValidatorsPLS() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("toValidatorsPLS"); return this._toEther(value); });
    }
    getValidatorsCount() {
        return __awaiter(this, void 0, void 0, function* () {
            let result = yield this._call("validatorsCount");
            if (!result)
                return 0;
            return parseInt(result);
        });
    }
    getLastUpdateTimestamp() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("lastUpdateTimestamp"); });
    }
    getRewardAddress() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("rewardAddress"); });
    }
    getStatsCollectorAddress() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("statsCollectorAddress"); });
    }
    getBnbAddress() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._call("bnbAddress"); });
    }
    update(withBNB) {
        return __awaiter(this, void 0, void 0, function* () { return yield this._send("update", withBNB); });
    }
    needUpdate() {
        return __awaiter(this, void 0, void 0, function* () { return yield this._callInSilence("needUpdate"); });
    }
    getBalance() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield this._call("getBalance");
            return this._toEther(res);
        });
    }
}
exports.ValidatorFeeReceiverContract = ValidatorFeeReceiverContract;
//# sourceMappingURL=ValidatorFeeReceiverContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/ValidatorStatsCollectorContract.js":
/*!******************************************************************!*\
  !*** ./bin/classes/contracts/ValidatorStatsCollectorContract.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValidatorStatsCollectorContract = exports.ValidatorStatResponse = exports.ValidatorStat = void 0;
const ContractFacade_1 = __webpack_require__(/*! ./abstact/ContractFacade */ "./bin/classes/contracts/abstact/ContractFacade.js");
const ValidatorStatsCollectorABI_1 = __webpack_require__(/*! ./abi/ValidatorStatsCollectorABI */ "./bin/classes/contracts/abi/ValidatorStatsCollectorABI.js");
class ValidatorStat {
}
exports.ValidatorStat = ValidatorStat;
class ValidatorStatResponse {
}
exports.ValidatorStatResponse = ValidatorStatResponse;
class ValidatorStatsCollectorContract extends ContractFacade_1.ContractFacade {
    constructor(address, web3) {
        super(address, web3, ValidatorStatsCollectorABI_1.ValidatorStatsCollectorABI.GetABI());
    }
    getTotalIncomePLS() {
        return __awaiter(this, void 0, void 0, function* () { const value = yield this._call("totalIncome"); return this._toEther(value); });
    }
    getStatsFromEnd(skip) {
        return __awaiter(this, void 0, void 0, function* () {
            const respose = yield this._call("getStatsFromEnd", skip);
            if (!respose)
                return respose;
            const result = new ValidatorStatResponse();
            result._length = respose._length + "";
            result.list = [];
            for (let r of respose.list) {
                const s = new ValidatorStat();
                s.acc = this._toEther(r.acc);
                s.profitPerValidator = this._toEther(r.profitPerValidator);
                s.timestamp = r.timestamp + "";
                result.list.push(s);
            }
            return result;
        });
    }
}
exports.ValidatorStatsCollectorContract = ValidatorStatsCollectorContract;
//# sourceMappingURL=ValidatorStatsCollectorContract.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/BurnableABI.js":
/*!**************************************************!*\
  !*** ./bin/classes/contracts/abi/BurnableABI.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BurnableABI = void 0;
class BurnableABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "amount",
                        "type": "uint256"
                    }
                ],
                "name": "burn",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            }
        ];
    }
}
exports.BurnableABI = BurnableABI;
//# sourceMappingURL=BurnableABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/BuyBurnPoolABI.js":
/*!*****************************************************!*\
  !*** ./bin/classes/contracts/abi/BuyBurnPoolABI.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BuyBurnPoolABI = void 0;
class BuyBurnPoolABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "manager_",
                        "type": "address"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [],
                "name": "BotPriorityInited",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "spentUSDL",
                        "type": "uint256"
                    }
                ],
                "name": "BoughtUp",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [],
                "name": "HalfATHPrice",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousManager",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "ManagmentshipTransferred",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousOwner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "OwnershipTransferred",
                "type": "event"
            },
            {
                "stateMutability": "payable",
                "type": "fallback"
            },
            {
                "inputs": [],
                "name": "botPriority",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "deposit",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "forATHEventUSDL",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "forSwapUSDL",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getBalance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "getBalanceToken",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getManager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getOwner",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getPendingGainForLOAN",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "usdl",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "pls",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getPendingGainForUSDL",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "loan",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "pls",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getStakedLOAN",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getStakedUSDL",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "initBotPriority",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "lastUpdateTimestamp",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "needUpdate",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "preBnBSeqTimestamp",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "priceATH",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "stakeLOAN",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "stakeUSDL",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "statistics",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "lastBoughtTimestamp",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "lastBoughtAmountUSDL",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "totalBoughtAmountUSDL",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "totalBurnUp",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "incomeUSDL",
                        "type": "uint256"
                    }
                ],
                "name": "swappedInternalPLS",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "takeGainForLOAN",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "takeGainForUSDL",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "transferManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "transferOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "unstakeLOAN",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "unstakeUSDL",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "update",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "updateInfrastructure",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "withdraw",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "withdrawToken",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "receive"
            }
        ];
    }
}
exports.BuyBurnPoolABI = BuyBurnPoolABI;
//# sourceMappingURL=BuyBurnPoolABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/ERC20ABI.js":
/*!***********************************************!*\
  !*** ./bin/classes/contracts/abi/ERC20ABI.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ERC20ABI = void 0;
class ERC20ABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "string",
                        "name": "name_",
                        "type": "string"
                    },
                    {
                        "internalType": "string",
                        "name": "symbol_",
                        "type": "string"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "owner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    },
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "value",
                        "type": "uint256"
                    }
                ],
                "name": "Approval",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "from",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "to",
                        "type": "address"
                    },
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "value",
                        "type": "uint256"
                    }
                ],
                "name": "Transfer",
                "type": "event"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "owner",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    }
                ],
                "name": "allowance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "amount",
                        "type": "uint256"
                    }
                ],
                "name": "approve",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "account",
                        "type": "address"
                    }
                ],
                "name": "balanceOf",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "decimals",
                "outputs": [
                    {
                        "internalType": "uint8",
                        "name": "",
                        "type": "uint8"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "subtractedValue",
                        "type": "uint256"
                    }
                ],
                "name": "decreaseAllowance",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "addedValue",
                        "type": "uint256"
                    }
                ],
                "name": "increaseAllowance",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "name",
                "outputs": [
                    {
                        "internalType": "string",
                        "name": "",
                        "type": "string"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "symbol",
                "outputs": [
                    {
                        "internalType": "string",
                        "name": "",
                        "type": "string"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "totalSupply",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "to",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "amount",
                        "type": "uint256"
                    }
                ],
                "name": "transfer",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "from",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "to",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "amount",
                        "type": "uint256"
                    }
                ],
                "name": "transferFrom",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            }
        ];
    }
}
exports.ERC20ABI = ERC20ABI;
//# sourceMappingURL=ERC20ABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/InternalExchangerBnBABI.js":
/*!**************************************************************!*\
  !*** ./bin/classes/contracts/abi/InternalExchangerBnBABI.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InternalExchangerBnBABI = void 0;
class InternalExchangerBnBABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "_manager",
                        "type": "address"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousManager",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "ManagmentshipTransferred",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousOwner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "OwnershipTransferred",
                "type": "event"
            },
            {
                "stateMutability": "payable",
                "type": "fallback"
            },
            {
                "inputs": [],
                "name": "canPickUpPLSReward",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "deposit",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getManager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getOwner",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "pickUpPLSReward",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "needSwapUSDL",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "price18dec",
                        "type": "uint256"
                    }
                ],
                "name": "swap",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "swappedUSDL",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "transferManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "transferOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "updateInfrastructure",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "receive"
            }
        ];
    }
}
exports.InternalExchangerBnBABI = InternalExchangerBnBABI;
//# sourceMappingURL=InternalExchangerBnBABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/InternalExchangerSPABI.js":
/*!*************************************************************!*\
  !*** ./bin/classes/contracts/abi/InternalExchangerSPABI.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InternalExchangerSPABI = void 0;
class InternalExchangerSPABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "_manager",
                        "type": "address"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousManager",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "ManagmentshipTransferred",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousOwner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "OwnershipTransferred",
                "type": "event"
            },
            {
                "stateMutability": "payable",
                "type": "fallback"
            },
            {
                "inputs": [],
                "name": "canPickUpPLSReward",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "deposit",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getManager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getOwner",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "pickUpPLSReward",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "needSwapUSDL",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "price18dec",
                        "type": "uint256"
                    }
                ],
                "name": "swap",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "swappedUSDL",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "transferManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "transferOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "updateInfrastructure",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "receive"
            }
        ];
    }
}
exports.InternalExchangerSPABI = InternalExchangerSPABI;
//# sourceMappingURL=InternalExchangerSPABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/LiquidControllerABI.js":
/*!**********************************************************!*\
  !*** ./bin/classes/contracts/abi/LiquidControllerABI.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LiquidControllerABI = void 0;
class LiquidControllerABI {
    static GetABI() {
        return [
            {
                "inputs": [],
                "name": "deposit",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "_manager",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "_owner",
                        "type": "address"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousManager",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "ManagmentshipTransferred",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousOwner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "OwnershipTransferred",
                "type": "event"
            },
            {
                "inputs": [],
                "name": "renounceManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "_llMinLoan",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_llGas",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_loanMinReTakeUSDL",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_swapMinUSDL",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_maxLoanDumpIndex",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_stabPoolSplitPartRevers",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_buyBurnSplitPartRevers",
                        "type": "uint256"
                    }
                ],
                "name": "setConfig",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "_targetICR",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_targetReloanICR",
                        "type": "uint256"
                    }
                ],
                "name": "setTargetICR",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "transferManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "transferOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "fallback"
            },
            {
                "inputs": [],
                "name": "update",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "updateInfrastructure",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "withdraw",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "withdrawToken",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "receive"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "_targetICR",
                        "type": "uint256"
                    }
                ],
                "name": "calcAdditionalLoanSize",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "_loan",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_coll",
                        "type": "uint256"
                    }
                ],
                "name": "calcICR",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "_targetICR",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_coll",
                        "type": "uint256"
                    }
                ],
                "name": "calcLoanSize",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getBalance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "getBalanceToken",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getColl",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getConfig",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "_llMinLoan",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_llGas",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_loanMinReTakeUSDL",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_swapMinUSDL",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_maxLoanDumpIndex",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_targetICR",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_targetReloanICR",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_stabPoolSplitPartRevers",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "_buyBurnSplitPartRevers",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getDebt",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getICR",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getManager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getOwner",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getStatus",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "needUpdate",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "vaultProxy",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            }
        ];
    }
}
exports.LiquidControllerABI = LiquidControllerABI;
//# sourceMappingURL=LiquidControllerABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/PriceKeeperABI.js":
/*!*****************************************************!*\
  !*** ./bin/classes/contracts/abi/PriceKeeperABI.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PriceKeeperABI = void 0;
class PriceKeeperABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "quoteToken",
                        "type": "address"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousOwner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "OwnershipTransferred",
                "type": "event"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "_pairSwapAddress",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "_priceKeeperAddress",
                        "type": "address"
                    }
                ],
                "name": "addPair",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "_pairSwapAddress",
                        "type": "address"
                    }
                ],
                "name": "addStaiblePair",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getCorrectionIndex",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "index",
                        "type": "uint256"
                    }
                ],
                "name": "getPairByIndex",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "pair",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "count",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "_amount18decimal",
                        "type": "uint256"
                    }
                ],
                "name": "getPrice",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getQuoteToken",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "_amount18decimal",
                        "type": "uint256"
                    },
                    {
                        "internalType": "address",
                        "name": "_fromSwapAddress",
                        "type": "address"
                    }
                ],
                "name": "getRecursionPrice",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "owner",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "reset",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "index18Decimal",
                        "type": "uint256"
                    }
                ],
                "name": "setCorrectionIndex",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "transferOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            }
        ];
    }
}
exports.PriceKeeperABI = PriceKeeperABI;
//# sourceMappingURL=PriceKeeperABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/ShareXABI.js":
/*!************************************************!*\
  !*** ./bin/classes/contracts/abi/ShareXABI.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ShareXABI = void 0;
class ShareXABI {
    static GetABI() {
        return [
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "owner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    },
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "value",
                        "type": "uint256"
                    }
                ],
                "name": "Approval",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "from",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "to",
                        "type": "address"
                    },
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "value",
                        "type": "uint256"
                    }
                ],
                "name": "Transfer",
                "type": "event"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "from",
                        "type": "address"
                    }
                ],
                "name": "allowSigleIncomeTransfer",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "amount",
                        "type": "uint256"
                    }
                ],
                "name": "approve",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Token",
                        "type": "address"
                    }
                ],
                "name": "consumeIncomeERC20",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "consumeIncomeETH",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "subtractedValue",
                        "type": "uint256"
                    }
                ],
                "name": "decreaseAllowance",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "deposit",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "addedValue",
                        "type": "uint256"
                    }
                ],
                "name": "increaseAllowance",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "lockIncomeTransfer",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "to",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "amount",
                        "type": "uint256"
                    }
                ],
                "name": "transfer",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "from",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "to",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "amount",
                        "type": "uint256"
                    }
                ],
                "name": "transferFrom",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "receive"
            },
            {
                "inputs": [],
                "name": "unlockIncomeTransfer",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "withdrawAll",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20",
                        "type": "address"
                    }
                ],
                "name": "withdrawERC20",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "withdrawETH",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "fallback"
            },
            {
                "inputs": [
                    {
                        "internalType": "string",
                        "name": "name_",
                        "type": "string"
                    },
                    {
                        "internalType": "string",
                        "name": "symbol_",
                        "type": "string"
                    },
                    {
                        "internalType": "uint256",
                        "name": "mintCount_",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "owner",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "spender",
                        "type": "address"
                    }
                ],
                "name": "allowance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "account",
                        "type": "address"
                    }
                ],
                "name": "balanceOf",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "decimals",
                "outputs": [
                    {
                        "internalType": "uint8",
                        "name": "",
                        "type": "uint8"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getBalance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "getBalanceToken",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "token",
                        "type": "address"
                    }
                ],
                "name": "getConsumedBalance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getConsumedBalanceETH",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "token",
                        "type": "address"
                    }
                ],
                "name": "getCost",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getCostETH",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "share",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "token",
                        "type": "address"
                    }
                ],
                "name": "getShareCost",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "share",
                        "type": "address"
                    }
                ],
                "name": "getShareCostETH",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "to",
                        "type": "address"
                    }
                ],
                "name": "isIncomeTransferLocked",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "name",
                "outputs": [
                    {
                        "internalType": "string",
                        "name": "",
                        "type": "string"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "symbol",
                "outputs": [
                    {
                        "internalType": "string",
                        "name": "",
                        "type": "string"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "name": "tokens",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "totalSupply",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "name": "usedTokens",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            }
        ];
    }
}
exports.ShareXABI = ShareXABI;
//# sourceMappingURL=ShareXABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/StabilityPoolABI.js":
/*!*******************************************************!*\
  !*** ./bin/classes/contracts/abi/StabilityPoolABI.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StabilityPoolABI = void 0;
class StabilityPoolABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "manager_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "internalExchangerBnB_",
                        "type": "address"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "ATHPrice",
                        "type": "uint256"
                    },
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "currentPrice",
                        "type": "uint256"
                    }
                ],
                "name": "ATHPriceDump",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousManager",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "ManagmentshipTransferred",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousOwner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "OwnershipTransferred",
                "type": "event"
            },
            {
                "stateMutability": "payable",
                "type": "fallback"
            },
            {
                "inputs": [],
                "name": "deposit",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getBalance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "getBalanceToken",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getManager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getOwner",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getPendingGainForLOAN",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "usdl",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "pls",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getPendingGainForUSDL",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "loan",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "pls",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getStakedLOAN",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getStakedUSDL",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "inSwapMode",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "lastUpdateTimestamp",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "needUpdate",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "pricePLS_ATH",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "pricePLStoSwap",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "stakeLOAN",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "stakeUSDL",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "takeGainForLOAN",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "takeGainForUSDL",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "transferManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "transferOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "unstakeLOAN",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "unstakeUSDL",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "update",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "updateInfrastructure",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "withdraw",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "withdrawToken",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "receive"
            }
        ];
    }
}
exports.StabilityPoolABI = StabilityPoolABI;
//# sourceMappingURL=StabilityPoolABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/UpManagerABI.js":
/*!***************************************************!*\
  !*** ./bin/classes/contracts/abi/UpManagerABI.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpManagerABI = void 0;
class UpManagerABI {
    static GetABI() {
        return [
            {
                "inputs": [],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousManager",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "ManagmentshipTransferred",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousOwner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "OwnershipTransferred",
                "type": "event"
            },
            {
                "stateMutability": "payable",
                "type": "fallback"
            },
            {
                "inputs": [],
                "name": "buyBurnPool",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "createLiquidController",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "delegatedSwapper",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "tradeBot_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "liquidControllersDeployer_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "internalExchangerSP_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "buyBurnPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "delegatedSwapper_",
                        "type": "address"
                    }
                ],
                "name": "deployStage4",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "stabilityPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "internalExchangerBnB_",
                        "type": "address"
                    }
                ],
                "name": "deployStage5",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "deposit",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getBalance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "getBalanceToken",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getBuyBurnPoolInfrastructure",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "stabilityPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "tradeBot_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "rewardPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "priceKeeperPLS_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "internalExchangerBnB_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "delegatedSwapper_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "tokenUP_",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getInternalExchangerInfrastructure",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "rewardPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "buyBurnPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "tokenUSDL_",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "index",
                        "type": "uint256"
                    }
                ],
                "name": "getLiquidController",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "liquidController",
                        "type": "address"
                    },
                    {
                        "internalType": "uint256",
                        "name": "count",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getLiquidControllerImmutable",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "tokenUSDL_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "llBorrower_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "llVaultManager_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "llHintHelpers_",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getLiquidControllerInfrastructure",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "priceKeeperPLS_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "delegatedSwapper_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "buyBurnPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "stabilityPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "rewardPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "internalExchangerBnB_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "internalExchangerSP_",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getManager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getOwner",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getStabilityPoolInfrastructure",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "buyBurnPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "rewardPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "internalExchangerSP_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "internalExchangerBnB_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "delegatedSwapper_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "priceKeeperPLS_",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getStakingLLPoolInfrastructure",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "llStakePool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "llStabilityPool_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "tokenUSDL_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "tokenLOAN_",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getUpdateSelectivelyArgs",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "bbPool",
                        "type": "bool"
                    },
                    {
                        "internalType": "bool",
                        "name": "sPool",
                        "type": "bool"
                    },
                    {
                        "internalType": "uint256[10]",
                        "name": "lcsIndexes",
                        "type": "uint256[10]"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "internalExchangerBnB",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "internalExchangerSP",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "contractAddress",
                        "type": "address"
                    }
                ],
                "name": "isLiquidController",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "contractAddress",
                        "type": "address"
                    }
                ],
                "name": "isValidForDelegatedSwap",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "contractAddress",
                        "type": "address"
                    }
                ],
                "name": "isValidForInternalExchanger",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "liquidControllersDeployer",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "llBorrower",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "llHintHelpers",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "llStabilityPool",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "llStakePool",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "llVaultManager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "needUpdate",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "priceKeeperPLS",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "priceKeeperUP",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "rewardPool",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "buyBurnPool_",
                        "type": "address"
                    }
                ],
                "name": "setBuyBurnPool",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "delegatedSwapper_",
                        "type": "address"
                    }
                ],
                "name": "setDelegatedSwapper",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "internalExchangerBnB_",
                        "type": "address"
                    }
                ],
                "name": "setInternalExchangerBnB",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "internalExchangerSP_",
                        "type": "address"
                    }
                ],
                "name": "setInternalExchangerSP",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "liquidControllersDeployer_",
                        "type": "address"
                    }
                ],
                "name": "setLiquidControllersDeployer",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "priceKeeperPLS_",
                        "type": "address"
                    }
                ],
                "name": "setPriceKeeperPLS",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "priceKeeperUP_",
                        "type": "address"
                    }
                ],
                "name": "setPriceKeeperUP",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "rewardPool_",
                        "type": "address"
                    }
                ],
                "name": "setRewardPool",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "stabilityPool_",
                        "type": "address"
                    }
                ],
                "name": "setStabilityPool",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "tradeBot_",
                        "type": "address"
                    }
                ],
                "name": "setTradeBot",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "stabilityPool",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "start",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "started",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "tokenLOAN",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "tokenUP",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "tokenUSDL",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "tradeBot",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "transferManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "transferOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "update",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "bool",
                        "name": "bbPool",
                        "type": "bool"
                    },
                    {
                        "internalType": "bool",
                        "name": "sPool",
                        "type": "bool"
                    },
                    {
                        "internalType": "uint256[]",
                        "name": "lcsIndexes",
                        "type": "uint256[]"
                    }
                ],
                "name": "updateSelectively",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "withdraw",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "withdrawToken",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "receive"
            }
        ];
    }
}
exports.UpManagerABI = UpManagerABI;
//# sourceMappingURL=UpManagerABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/ValidatorBnBABI.js":
/*!******************************************************!*\
  !*** ./bin/classes/contracts/abi/ValidatorBnBABI.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValidatorBnBABI = void 0;
class ValidatorBnBABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "manager_",
                        "type": "address"
                    },
                    {
                        "internalType": "address",
                        "name": "owner_",
                        "type": "address"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousManager",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "ManagmentshipTransferred",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "amountPLS",
                        "type": "uint256"
                    },
                    {
                        "indexed": false,
                        "internalType": "uint256",
                        "name": "amountUP",
                        "type": "uint256"
                    }
                ],
                "name": "OnSwap",
                "type": "event"
            },
            {
                "anonymous": false,
                "inputs": [
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "previousOwner",
                        "type": "address"
                    },
                    {
                        "indexed": true,
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "OwnershipTransferred",
                "type": "event"
            },
            {
                "stateMutability": "payable",
                "type": "fallback"
            },
            {
                "inputs": [],
                "name": "deposit",
                "outputs": [],
                "stateMutability": "payable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getBalance",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "getBalanceToken",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getManager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "getOwner",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "lastSwapTimestamp",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "needUpdate",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "renounceOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "statistics",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "lastSwapTimestamp",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "lastSwapAmountPLS",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "totalSwapAmountPLS",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "totalBurnUp",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "swapRouterV2",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "tokenUP",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "tokenWPLS",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newManager",
                        "type": "address"
                    }
                ],
                "name": "transferManagmentship",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "newOwner",
                        "type": "address"
                    }
                ],
                "name": "transferOwnership",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "update",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "withdraw",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "erc20Address",
                        "type": "address"
                    }
                ],
                "name": "withdrawToken",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "stateMutability": "payable",
                "type": "receive"
            }
        ];
    }
}
exports.ValidatorBnBABI = ValidatorBnBABI;
//# sourceMappingURL=ValidatorBnBABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/ValidatorFeeReceiverABI.js":
/*!**************************************************************!*\
  !*** ./bin/classes/contracts/abi/ValidatorFeeReceiverABI.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValidatorFeeReceiverABI = void 0;
class ValidatorFeeReceiverABI {
    static GetABI() {
        return [
            {
                "inputs": [],
                "name": "bnbAddress",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "lastUpdateTimestamp",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "lockSplitting",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "needUpdate",
                "outputs": [
                    {
                        "internalType": "bool",
                        "name": "needUpdate_",
                        "type": "bool"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "rewardAddress",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "statsCollectorAddress",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "toValidatorsPLS",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "bool",
                        "name": "withBNB",
                        "type": "bool"
                    }
                ],
                "name": "update",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "validatorsCount",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            }
        ];
    }
}
exports.ValidatorFeeReceiverABI = ValidatorFeeReceiverABI;
//# sourceMappingURL=ValidatorFeeReceiverABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abi/ValidatorStatsCollectorABI.js":
/*!*****************************************************************!*\
  !*** ./bin/classes/contracts/abi/ValidatorStatsCollectorABI.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValidatorStatsCollectorABI = void 0;
class ValidatorStatsCollectorABI {
    static GetABI() {
        return [
            {
                "inputs": [
                    {
                        "internalType": "address",
                        "name": "manager_",
                        "type": "address"
                    }
                ],
                "stateMutability": "nonpayable",
                "type": "constructor"
            },
            {
                "inputs": [],
                "name": "currentStat",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "timestamp",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "acc",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "profitPerValidator",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "skip",
                        "type": "uint256"
                    }
                ],
                "name": "getStatsFromEnd",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "length",
                        "type": "uint256"
                    },
                    {
                        "components": [
                            {
                                "internalType": "uint256",
                                "name": "timestamp",
                                "type": "uint256"
                            },
                            {
                                "internalType": "uint256",
                                "name": "acc",
                                "type": "uint256"
                            },
                            {
                                "internalType": "uint256",
                                "name": "profitPerValidator",
                                "type": "uint256"
                            }
                        ],
                        "internalType": "struct StatsCollector.StatData[52]",
                        "name": "list",
                        "type": "tuple[52]"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "manager",
                "outputs": [
                    {
                        "internalType": "address",
                        "name": "",
                        "type": "address"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [],
                "name": "totalIncome",
                "outputs": [
                    {
                        "internalType": "uint256",
                        "name": "",
                        "type": "uint256"
                    }
                ],
                "stateMutability": "view",
                "type": "function"
            },
            {
                "inputs": [
                    {
                        "internalType": "uint256",
                        "name": "income",
                        "type": "uint256"
                    },
                    {
                        "internalType": "uint256",
                        "name": "validatorsCount",
                        "type": "uint256"
                    }
                ],
                "name": "update",
                "outputs": [],
                "stateMutability": "nonpayable",
                "type": "function"
            }
        ];
    }
}
exports.ValidatorStatsCollectorABI = ValidatorStatsCollectorABI;
//# sourceMappingURL=ValidatorStatsCollectorABI.js.map

/***/ }),

/***/ "./bin/classes/contracts/abstact/ContractFacade.js":
/*!*********************************************************!*\
  !*** ./bin/classes/contracts/abstact/ContractFacade.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContractFacade = void 0;
const App_1 = __webpack_require__(/*! ../../App */ "./bin/classes/App.js");
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const gs = __webpack_require__(/*! @ivanlog/gs */ "./node_modules/@ivanlog/gs/index.js");
class ContractFacade {
    constructor(address, web3, abi) {
        this._address = address;
        this._contract = new web3.eth.Contract(abi, address);
        this._web3 = web3;
        this._abi = abi;
    }
    updateWeb3(web3) {
        this._contract = new web3.eth.Contract(this._abi, this._address);
        this._web3 = web3;
    }
    get address() { return this._address; }
    get web3() { return this._web3; }
    _call(method, ...args) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield this._contract.methods[method](...args).call();
            }
            catch (e) {
                new modalCom.DialogOk(gs.text.clearHtmlToText(e.message), "Blockchain call error at " + this._address).show();
            }
        });
    }
    _callInSilence(method, ...args) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield this._contract.methods[method](...args).call();
            }
            catch (e) { }
        });
    }
    _send(method, ...args) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let gas = yield this._contract.methods[method](...args).estimateGas({ from: App_1.App.Inst.chain.account });
            }
            catch (e) {
                this._informChainError(e.data);
                return undefined;
            }
            try {
                return yield this._contract.methods[method](...args).send({ from: App_1.App.Inst.chain.account });
            }
            catch (e) {
                new modalCom.DialogOk(gs.text.clearHtmlToText(e.message), "Blockchain send error at " + this._address).show();
            }
        });
    }
    _pay(value, method, ...args) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let gas = yield this._contract.methods[method](...args).estimateGas({ value: value, from: App_1.App.Inst.chain.account });
            }
            catch (e) {
                this._informChainError(e.data);
                return undefined;
            }
            try {
                return yield this._contract.methods[method](...args).send({ value: value, from: App_1.App.Inst.chain.account });
            }
            catch (e) {
                new modalCom.DialogOk(gs.text.clearHtmlToText(e.message), "Blockchain pay error at " + this._address).show();
            }
        });
    }
    _toDecimal(wei) {
        let value = this._web3.utils.fromWei(wei, "ether");
        if (value == "0.")
            value = "0.0";
        return value;
    }
    _toEther(wei) {
        return this._toDecimal(wei);
    }
    _toWei(ether) {
        return this._web3.utils.toWei(ether, "ether");
    }
    _div(hexValue, div) {
        const decimalString = this._web3.utils.hexToNumberString(hexValue);
        const decimalNumber = BigInt(decimalString);
        const dividedNumber = decimalNumber / BigInt(div);
        const hexResult = '0x' + dividedNumber.toString(16);
        return hexResult;
    }
    _informChainError(data) {
        let message = "";
        if (data.originalError)
            data = data.originalError;
        if (data)
            if (data.message)
                message = gs.text.clearHtmlToText(data.message);
        if (message)
            message = gs.text.uppercaseFirstLetter(message);
        if (message)
            new modalCom.DialogOk("Something wrong. " + message, "Blockchain error").show();
        else
            new modalCom.DialogOk("Something wrong", "Blockchain error").show();
    }
}
exports.ContractFacade = ContractFacade;
//# sourceMappingURL=ContractFacade.js.map

/***/ }),

/***/ "./bin/classes/enums/DesignThemeEnum.js":
/*!**********************************************!*\
  !*** ./bin/classes/enums/DesignThemeEnum.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DesignThemeEnum = void 0;
var DesignThemeEnum;
(function (DesignThemeEnum) {
    DesignThemeEnum["LightGrey"] = "lightgrey";
    DesignThemeEnum["Grey"] = "grey";
    DesignThemeEnum["Dark"] = "dark";
})(DesignThemeEnum = exports.DesignThemeEnum || (exports.DesignThemeEnum = {}));
//# sourceMappingURL=DesignThemeEnum.js.map

/***/ }),

/***/ "./bin/classes/enums/VaultControllerStatusEnum.js":
/*!********************************************************!*\
  !*** ./bin/classes/enums/VaultControllerStatusEnum.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {

﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VaultControllerStatusEnum = void 0;
var VaultControllerStatusEnum;
(function (VaultControllerStatusEnum) {
    //0 - Created 1 - Splitting 2 - Swapping 3 - WaitICR 
    VaultControllerStatusEnum[VaultControllerStatusEnum["Created"] = 0] = "Created";
    VaultControllerStatusEnum[VaultControllerStatusEnum["Splitting"] = 1] = "Splitting";
    VaultControllerStatusEnum[VaultControllerStatusEnum["Swapping"] = 2] = "Swapping";
    VaultControllerStatusEnum[VaultControllerStatusEnum["WaitTargetICR"] = 3] = "WaitTargetICR";
    VaultControllerStatusEnum[VaultControllerStatusEnum["VaultClosed"] = 4] = "VaultClosed";
})(VaultControllerStatusEnum = exports.VaultControllerStatusEnum || (exports.VaultControllerStatusEnum = {}));
//# sourceMappingURL=VaultControllerStatusEnum.js.map

/***/ }),

/***/ "./bin/classes/states/StateDashboard.js":
/*!**********************************************!*\
  !*** ./bin/classes/states/StateDashboard.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StateDashboard = void 0;
const PriceKeeperView_1 = __webpack_require__(/*! ../com/contractViews/PriceKeeperView */ "./bin/classes/com/contractViews/PriceKeeperView.js");
const com = __webpack_require__(/*! ../com/tmpls */ "./bin/classes/com/tmpls.js");
const UpManagerView_1 = __webpack_require__(/*! ../com/contractViews/UpManagerView */ "./bin/classes/com/contractViews/UpManagerView.js");
const StatePaged_1 = __webpack_require__(/*! ./abstracts/StatePaged */ "./bin/classes/states/abstracts/StatePaged.js");
const BuyBurnPoolView_1 = __webpack_require__(/*! ../com/contractViews/BuyBurnPoolView */ "./bin/classes/com/contractViews/BuyBurnPoolView.js");
const LiquidControllerView_1 = __webpack_require__(/*! ../com/contractViews/LiquidControllerView */ "./bin/classes/com/contractViews/LiquidControllerView.js");
const StabilityPoolView_1 = __webpack_require__(/*! ../com/contractViews/StabilityPoolView */ "./bin/classes/com/contractViews/StabilityPoolView.js");
const InternalExchangerBnBView_1 = __webpack_require__(/*! ../com/contractViews/InternalExchangerBnBView */ "./bin/classes/com/contractViews/InternalExchangerBnBView.js");
const InternalExchangerSPView_1 = __webpack_require__(/*! ../com/contractViews/InternalExchangerSPView */ "./bin/classes/com/contractViews/InternalExchangerSPView.js");
const UPTokenView_1 = __webpack_require__(/*! ../com/contractViews/UPTokenView */ "./bin/classes/com/contractViews/UPTokenView.js");
const ERC20Contract_1 = __webpack_require__(/*! ../contracts/ERC20Contract */ "./bin/classes/contracts/ERC20Contract.js");
class StateDashboard extends StatePaged_1.StatePaged {
    constructor() {
        super(com.PageDashboard, "uPX ecosystem dashboard", true, false);
        this._geekClickCounter = 0;
        this._statsViews = [];
    }
    start() {
        const _super = Object.create(null, {
            start: { get: () => super.start }
        });
        return __awaiter(this, void 0, void 0, function* () {
            this.gui.showPage(this.page);
            const blockPrices = new com.CmpBlockPriceKeepers();
            this.page.ctrls.blocks.append(blockPrices);
            this._priceKeeperViewPLS = new PriceKeeperView_1.PriceKeeperView(this.app.chain.priceKeeperPLS, "USD");
            this._priceKeeperViewPLS.refresh();
            blockPrices.ctrls.blockPrices.append(this._priceKeeperViewPLS);
            this._priceKeeperViewUp = new PriceKeeperView_1.PriceKeeperView(this.app.chain.priceKeeperUP, "USDL");
            this._priceKeeperViewUp.refresh();
            blockPrices.ctrls.blockPrices.append(this._priceKeeperViewUp);
            const blockUpTotal = new UPTokenView_1.UPTokenView(new ERC20Contract_1.ERC20Contract(this.app.chain.addressTokenUP, this.app.chain.web3), this.app.chain.burnableUp);
            blockUpTotal.refresh();
            this.page.ctrls.blocks.append(blockUpTotal);
            const blockUpManager = new UpManagerView_1.UpManagerView(this.app.chain.upManager);
            this.page.ctrls.blocks.append(blockUpManager);
            blockUpManager.ctrls.imgLogo.onclick = () => this.initGeekAreaAsync();
            yield this.feelStatsAsync();
            if (globalThis.showChart) {
                const blockChart = new com.CmpBlockChart();
                this.page.ctrls.blocks.append(blockChart);
                globalThis.showChart('1hour');
            }
            return _super.start.call(this);
        });
    }
    initGeekAreaAsync() {
        return __awaiter(this, void 0, void 0, function* () {
            this._geekClickCounter++;
            if (this._geekClickCounter != 5)
                return;
            const blockExchangers = new com.CmpBlockInternalExchangers();
            let internalExchangerBnB = new InternalExchangerBnBView_1.InternalExchangerBnBView(this.app.chain.internalExchangerBnB);
            blockExchangers.ctrls.blockExchangers.append(internalExchangerBnB);
            internalExchangerBnB.refresh();
            let internalExchangerSP = new InternalExchangerSPView_1.InternalExchangerSPView(this.app.chain.internalExchangerSP);
            blockExchangers.ctrls.blockExchangers.append(internalExchangerSP);
            internalExchangerSP.refresh();
            this.page.ctrls.blocks.append(blockExchangers);
            const blockPools = new com.CmpBlockPools();
            let bbPool = new BuyBurnPoolView_1.BuyBurnPoolView(this.app.chain.buyBurnPool);
            blockPools.ctrls.blockPools.append(bbPool);
            bbPool.refresh();
            let stabPool = new StabilityPoolView_1.StabilityPoolView(this.app.chain.stabilityPool);
            blockPools.ctrls.blockPools.append(stabPool);
            stabPool.refresh();
            this.page.ctrls.blocks.append(blockPools);
            const blockContactsVaults = new com.CmpBlockContracts();
            this.page.ctrls.blocks.append(blockContactsVaults);
            for (const vc of this.app.chain.liquidControllers) {
                let vault = new LiquidControllerView_1.LiquidControllerView(vc);
                blockContactsVaults.ctrls.blockContainer.append(vault);
                vault.refresh();
            }
        });
    }
    feelStatsAsync() {
        return __awaiter(this, void 0, void 0, function* () {
            const ef = (e, d = 3) => this._ethToFormat(e + "", d);
            const blockStats = new com.CmpBlockStatsContainer();
            this.page.ctrls.blocks.append(blockStats);
            const addStatFunc = (header, text, desc) => {
                let stat = new com.CmpStatsItem();
                stat.ctrls.lHeader.text = header;
                stat.ctrls.lText.text = text;
                stat.ctrls.lDescription.text = desc;
                blockStats.ctrls.blockContainer.append(stat);
                stat.onclick = () => {
                    if (stat.ctrls.lText.hasClass('hidden')) {
                        stat.ctrls.lText.removeClass('hidden');
                        stat.ctrls.lDescription.addClass('hidden');
                    }
                    else {
                        stat.ctrls.lText.addClass('hidden');
                        stat.ctrls.lDescription.removeClass('hidden');
                    }
                };
                this._statsViews.push(stat);
                return stat;
            };
            const bnbStats = yield this.app.chain.buyBurnPool.getStatistics();
            const spStakedLoan = yield this.app.chain.stabilityPool.getStakedLOAN();
            const spStakedUSDL = yield this.app.chain.stabilityPool.getStakedUSDL();
            const spATHPrice = yield this.app.chain.stabilityPool.getPricePLS_ATH();
            const bbpStakedLoan = yield this.app.chain.buyBurnPool.getStakedLOAN();
            const bbpStakedUSDL = yield this.app.chain.buyBurnPool.getStakedUSDL();
            const bbpATHPrice = yield this.app.chain.buyBurnPool.getPriceATH();
            let bwAsset = 0;
            let nextLoanStatItem;
            // State
            addStatFunc("State", "Working", "Current state of the uPX ecosystem contracts.");
            // Last Buy
            {
                var date = new Date(parseFloat(bnbStats.lastBoughtTimestamp) * 1000);
                let dateString = "";
                if (parseFloat(bnbStats.lastBoughtAmountUSDL) != 0) {
                    const month = date.toLocaleString('default', { month: 'long' });
                    dateString = `\n${month.charAt(0).toUpperCase() + month.slice(1)} ${date.getDate()} ${date.getFullYear()}`;
                }
                addStatFunc("Last Buy", `${this._ethToFormat(bnbStats.lastBoughtAmountUSDL)} USDL\n${dateString}`, "Last Buy amount, including reloan and staking rewards. Below is the date when the buy happened.");
            }
            // Total of B&B Pool
            {
                let upPrice = parseFloat(this._priceKeeperViewUp.getLastPrice());
                let totalUp = parseFloat(bnbStats.totalBurnUp);
                let burnedIndex = parseFloat(bnbStats.totalBurnUp) / 51869006448;
                addStatFunc("Buy & Burn Stats", `uPX Burned:\n${this._ethToFormat(bnbStats.totalBurnUp)} (${this._ethToFormat(burnedIndex * 100 + "", 1)}%)\nUSDL spent: ${this._ethToFormat(bnbStats.totalBoughtAmountUSDL)} USD`, "Total amount includes the total amount of USDL sold for uPX, amount of uPX burned, and the value of the burned amount at the current price of uPX.");
            }
            //Next Loan
            {
                nextLoanStatItem = addStatFunc("Next Loan", "", "Price of Pulse needed to take out the next loan for Buy and Burn.");
            }
            //************************************************//
            let nextLoanPrice = 0;
            let vaultId = 0;
            for (const v of this.app.chain.liquidControllers) {
                vaultId++;
                let conf = yield v.getConfig();
                let coll = yield v.getColl();
                let debt = yield v.getDebt();
                let plsPrice = parseFloat(this._priceKeeperViewPLS.getLastPrice());
                let collPriced = parseFloat(coll) * plsPrice + "";
                bwAsset += parseFloat(collPriced) - parseFloat(debt);
                let icr = parseFloat(collPriced) / parseFloat(debt);
                let sm = 1.1 / icr;
                let liqPrice = 1.1 / icr * plsPrice;
                let nLoanPrice = parseFloat(conf.targetReloanICR) / icr * plsPrice;
                if (nextLoanPrice == 0 || nextLoanPrice > nLoanPrice)
                    nextLoanPrice = nLoanPrice;
                let targetICR = Math.round(parseFloat(conf.targetReloanICR) * 1000) / 10 + ""; // parseInt(+"")/10;
                addStatFunc("Vault " + vaultId, `ICR: ${this._ethToFormat(icr * 100 + "")}%\n Target ICR: ${targetICR}%`, "Vault's current ICR and the ICR setting for when to take out the next loan.");
                addStatFunc("Collateral", `${this._ethToFormat(coll)} PLS\n ${this._ethToFormat(collPriced)} USD`, "Vault collateral level in Pulse and its value at the current price of PLS.");
                addStatFunc("Total Loan", `${this._ethToFormat(debt)} USDL`, "Total amount of the loan taken out from the vault.");
                addStatFunc("Liquidation", `PLS price: ${this._ethToFormat(liqPrice + "")} USD\nSafety Margin: ${this._ethToFormat((100 - sm * 100) + "")}%`, "Liquidation price of PLS required to liquidate the vault with a price safety margin - the percentage drop in the price of PLS needed to reach the 110 ICR.");
            }
            if (nextLoanPrice != 0 && nextLoanStatItem != null) {
                nextLoanStatItem.ctrls.lText.text = `PLS price: ${this._ethToFormat(nextLoanPrice + "")} USD`;
            }
            //************************************************//
            //Stability Pool
            {
                addStatFunc("Stability Pool", `Staked:\n ${this._ethToFormat(spStakedUSDL)} USDL\n${this._ethToFormat(spStakedLoan)} LOAN`, "Total amount of staked assets in the Stability Pool in USDL and LOAN.");
                bwAsset += parseFloat(spStakedUSDL);
            }
            //Buy&Burn Pool
            {
                let halfATHPrice = parseFloat(bbpATHPrice) / 2 + '';
                addStatFunc("Buy&Burn Pool", `ATH/2 PLS price: ${this._ethToFormat(halfATHPrice)} USD\nStaked:\n ${this._ethToFormat(bbpStakedUSDL)} USDL\n${this._ethToFormat(bbpStakedLoan)} LOAN`, "Total amount of staked assets in the Buy and Burn Pool in USDL and LOAN.");
                bwAsset += parseFloat(bbpStakedUSDL);
            }
            //BW Assets
            {
                addStatFunc("BWX Assets", `~ ${this._ethToFormat(bwAsset + "")} USD\nPumping uPX`, "Current value of assets to pump uPX.");
            }
            //New Vault
            {
                addStatFunc("New Vault", `PLS price: ${this._ethToFormat(parseFloat(spATHPrice) * 0.35 + "")} USD`, "Price point of PLS to open a new vault.");
            }
            //************************************************//
            let validatorsCount = yield this.app.chain.validatorsManager.getValidatorsCount();
            if (!validatorsCount)
                validatorsCount = 0;
            const stakePerValidator = 32000000;
            const validatorsStakedTotal = validatorsCount * stakePerValidator;
            //Validators
            {
                addStatFunc("Validators", `Online: ${validatorsCount}\n Staked:\n ${ef(validatorsStakedTotal)} PLS`, "Total number of validators online with staked PLS amount.");
            }
            //Validator Yield
            {
                const totalIncomePLS = yield this.app.chain.validatorsStats.getTotalIncomePLS();
                const stats = yield this.app.chain.validatorsStats.getStatsFromEnd(0);
                while (true) {
                    if (stats.list.length == 0)
                        break;
                    const last = stats.list.pop();
                    if (last.timestamp == "0")
                        continue;
                    stats.list.push(last);
                    break;
                }
                if (stats.list.length > 0)
                    stats.list.pop(); //извлекаем первую неделю
                let weekAcc = 0;
                let weekIndex = 0;
                let monthAcc = 0;
                let monthIndex = 0;
                let yearAcc = 0;
                let yearIndex = 0;
                let i = 0;
                for (let stat of stats.list) {
                    i++;
                    if (i <= 1) {
                        weekAcc += parseFloat(stat.acc);
                        weekIndex += parseFloat(stat.profitPerValidator);
                    }
                    if (i <= 4) {
                        monthAcc += parseFloat(stat.acc);
                        monthIndex += parseFloat(stat.profitPerValidator);
                    }
                    if (i <= 52) {
                        yearAcc += parseFloat(stat.acc);
                        yearIndex += parseFloat(stat.profitPerValidator);
                    }
                }
                if (i < 4) {
                    monthAcc = monthAcc / i / 7 * 30;
                    monthIndex = monthIndex / i / 7 * 30;
                }
                if (i < 52) {
                    yearAcc = yearAcc / i * 52;
                    yearIndex = yearIndex / i * 52;
                }
                weekIndex = parseInt(weekIndex / 32000000 * 10000 + "") / 100;
                monthIndex = parseInt(monthIndex / 32000000 * 1000 + "") / 10;
                yearIndex = parseInt(yearIndex / 32000000 * 1000 + "") / 10;
                let message = `Week: Calculating\nTotal: ${ef(totalIncomePLS, 0)} PLS`;
                if (weekIndex > 0)
                    message = `Week: ${ef(weekAcc, 0)} PLS (${weekIndex}%)\nMonth: ${ef(monthAcc, 0)} PLS (${monthIndex}%)\nYear: ${ef(yearAcc, 0)} PLS (${yearIndex}%)\nTotal: ${ef(totalIncomePLS, 0)} PLS`;
                addStatFunc("Validator Yield", message, "Factual yield from validators online for the last known period, projects potential yield for longer periods.");
            }
            //Validator B&B
            {
                const stats = yield this.app.chain.validatorsBnB.getStatistic();
                const lastSwapPLS = stats.lastSwapAmountPLS;
                const spentPLS = stats.totalSwapAmountPLS;
                const bnbUp = stats.totalBurnUp;
                var date = new Date(parseFloat(stats.lastSwapTimestamp) * 1000);
                let dateString = "";
                if (parseFloat(lastSwapPLS) != 0) {
                    const month = date.toLocaleString('default', { month: 'long' });
                    dateString = `\n${month.charAt(0).toUpperCase() + month.slice(1)} ${date.getDate()} ${date.getFullYear()}`;
                }
                addStatFunc("Validator B&B", `Last B&B: ${ef(lastSwapPLS)} PLS\n${dateString}\nBurned:${ef(bnbUp)} uPX\nSpent: ${ef(spentPLS)} PLS`, "Last buy and burn amount with date, total uPX burned and total PLS spent from validator yield.");
            }
            //New Validator
            {
                let toNewValidator = parseFloat(yield this.app.chain.validatorsManager.getToValidatorsPLS());
                while (toNewValidator > 32000000)
                    toNewValidator - 32000000;
                toNewValidator = 32000000 - toNewValidator;
                addStatFunc("New Validator", `PLS to new: ${ef(toNewValidator + "")} PLS`, "Validator yield accumulates to get more validators online. Each key associated with a validator requires locking 32,000,000 PLS to be activated. New validator incoming when PLS to new: 0 PLS.");
            }
            this._startAnimationTask();
        });
    }
    _startAnimationTask() {
        return __awaiter(this, void 0, void 0, function* () {
            let index = 0;
            let descAction = true;
            const animFunc = () => {
                let stat = this._statsViews[index];
                if (descAction) {
                    descAction = false;
                    stat.ctrls.lText.addClass('hidden');
                    stat.ctrls.lDescription.removeClass('hidden');
                    setTimeout(animFunc, 6000);
                }
                else {
                    descAction = true;
                    stat.ctrls.lText.removeClass('hidden');
                    stat.ctrls.lDescription.addClass('hidden');
                    index++;
                    if (index >= this._statsViews.length)
                        index = 0;
                    stat = this._statsViews[index];
                    setTimeout(animFunc, 1000);
                }
            };
            animFunc();
        });
    }
    _ethToFormat(eth, del = 3) { return this.app.chain.ethToFormat(eth, del); }
}
exports.StateDashboard = StateDashboard;
StateDashboard.StateName = "dashboard";
//# sourceMappingURL=StateDashboard.js.map

/***/ }),

/***/ "./bin/classes/states/StateLoading.js":
/*!********************************************!*\
  !*** ./bin/classes/states/StateLoading.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StateLoading = void 0;
const com = __webpack_require__(/*! ../com/tmpls */ "./bin/classes/com/tmpls.js");
const StatePaged_1 = __webpack_require__(/*! ./abstracts/StatePaged */ "./bin/classes/states/abstracts/StatePaged.js");
class StateLoading extends StatePaged_1.StatePaged {
    constructor() {
        super(com.PageLoading, "uPX", true, false);
        this._sid = "";
    }
    start() {
        const _super = Object.create(null, {
            start: { get: () => super.start }
        });
        return __awaiter(this, void 0, void 0, function* () {
            this.gui.topBar.hide();
            return _super.start.call(this);
        });
    }
}
exports.StateLoading = StateLoading;
StateLoading.StateName = "login";
//# sourceMappingURL=StateLoading.js.map

/***/ }),

/***/ "./bin/classes/states/abstracts/StatePaged.js":
/*!****************************************************!*\
  !*** ./bin/classes/states/abstracts/StatePaged.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StatePaged = void 0;
const StateUp_1 = __webpack_require__(/*! ./StateUp */ "./bin/classes/states/abstracts/StateUp.js");
class StatePaged extends StateUp_1.StateUp {
    constructor(type, title, inHistory, withNavBars = true) {
        super(title, inHistory);
        this.withNavBars = false;
        this.page = new type();
        this.withNavBars = withNavBars;
    }
    afterStart(args) {
        const _super = Object.create(null, {
            afterStart: { get: () => super.afterStart }
        });
        return __awaiter(this, void 0, void 0, function* () {
            if (this.page)
                this.app.gui.showPage(this.page);
            if (this.withNavBars) {
                this.app.gui.topBar.show();
            }
            else {
                this.app.gui.topBar.hide();
            }
            this.setLabel(this.title);
            yield _super.afterStart.call(this, args);
        });
    }
    setLabel(text) {
        this.app.gui.topBar.ctrls.label.text = text;
    }
}
exports.StatePaged = StatePaged;
//# sourceMappingURL=StatePaged.js.map

/***/ }),

/***/ "./bin/classes/states/abstracts/StateUp.js":
/*!*************************************************!*\
  !*** ./bin/classes/states/abstracts/StateUp.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

﻿
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StateUp = void 0;
const gs_1 = __webpack_require__(/*! @ivanlog/gs */ "./node_modules/@ivanlog/gs/index.js");
class StateUp extends gs_1.StateGS {
    constructor(title, inHistory) {
        super(title, inHistory);
    }
    get app() { return StateUp.App; }
    get gui() { return this.app.gui; }
    lockgui(action) {
        return __awaiter(this, void 0, void 0, function* () { return this.app.gui.lockAction(action); });
    }
}
exports.StateUp = StateUp;
//# sourceMappingURL=StateUp.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs-com-modal_dialogs/ModalDialog.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ivanlog/gs-com-modal_dialogs/ModalDialog.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Implement = exports.DialogOkNoCancel = exports.DialogOkNo = exports.DialogOk = exports.AbstractDialog = exports.ModalDialogResult = void 0;
const gs = __webpack_require__(/*! @ivanlog/gs */ "./node_modules/@ivanlog/gs/index.js");
var ModalDialogResult;
(function (ModalDialogResult) {
    ModalDialogResult[ModalDialogResult["Ok"] = 0] = "Ok";
    ModalDialogResult[ModalDialogResult["No"] = 1] = "No";
    ModalDialogResult[ModalDialogResult["Cancel"] = 2] = "Cancel";
})(ModalDialogResult = exports.ModalDialogResult || (exports.ModalDialogResult = {}));
;
class AbstractDialogControls {
    constructor(ctrls) {
        this._ctrls = ctrls;
        this.container = this._ctrls.get('container');
        this.content = this._ctrls.get('content');
        this.header = this._ctrls.get('header');
        this.body = this._ctrls.get('body');
        this.footer = this._ctrls.get('footer');
        this.textTitle = this._ctrls.get('textTitle');
        this.btnClose = this._ctrls.get('btnClose');
        this.btnOk = this._ctrls.get('btnOk');
        this.btnNo = this._ctrls.get('btnNo');
        this.btnCancel = this._ctrls.get('btnCancel');
    }
}
class AbstractDialog extends gs.ComponentGS {
    constructor(message, title = '') {
        let tmpl = AbstractDialog.HtmlTemplate;
        if (gs.TemplateGS.TagDataControlName !== "tmpl")
            tmpl = gs.text.replaceAll(tmpl, "data-tmpl", "data-" + gs.TemplateGS.TagDataControlName);
        const templDiv = gs.html.div({}, "");
        templDiv.innerHTML = tmpl;
        const viewTmpl = templDiv.querySelector('.gs-com-modal_dialog');
        super(viewTmpl, AbstractDialogControls);
        this.ctrls.body.html = message;
        this.ctrls.textTitle.html = title;
        this.ctrls.btnOk.onclick = () => this.hide(ModalDialogResult.Ok);
        this.ctrls.btnNo.onclick = () => this.hide(ModalDialogResult.No);
        this.ctrls.btnCancel.onclick = () => this.hide();
        this.ctrls.btnClose.onclick = () => this.hide();
        this.ctrls.container.onclick = () => this.hide();
        this.ctrls.content.onclick = (e) => gs.events.stop(e);
    }
    show() {
        if (this._promise)
            return this._promise;
        this._promise = new Promise((resolve) => {
            this._promiseResolve = resolve;
            if (!this.el.parentElement)
                gs.q('body').append(this);
            super.show();
        });
        return this._promise;
    }
    hide(result = ModalDialogResult.Cancel) {
        if (this._promise)
            this._promiseResolve(result);
        this._closeAndClear();
    }
    _closeAndClear() {
        super.hide();
        this.cut();
        this._promise = undefined;
        this._promiseResolve = undefined;
    }
}
exports.AbstractDialog = AbstractDialog;
AbstractDialog.HtmlTemplate = `<div class="gs-com-modal_dialog">                
    <div class="modal-container" data-tmpl="container">
        <div class="modal-content" data-tmpl="content">
            <div class="modal-header" data-tmpl="header">
                <h5 data-tmpl="textTitle"></h5>
                <button class="modal-btn_top" data-tmpl="btnClose">&times;</button>
            </div>
            <div class="modal-body" data-tmpl="body"></div>
            <div class="modal-footer" data-tmpl="footer">
                <button class="modal-btn" data-tmpl="btnOk">Yes</button>
                <button class="modal-btn" data-tmpl="btnNo">No</button>
                <button class="modal-btn" data-tmpl="btnCancel">Cancel</button>
            </div>
        </div>
    </div>
</div>`;
class DialogOk extends AbstractDialog {
    constructor(message, title = '') {
        super(message, title);
        this.ctrls.btnNo.hide();
        this.ctrls.btnCancel.hide();
    }
}
exports.DialogOk = DialogOk;
class DialogOkNo extends AbstractDialog {
    constructor(message, title = '') {
        super(message, title);
        this.ctrls.btnCancel.hide();
    }
}
exports.DialogOkNo = DialogOkNo;
class DialogOkNoCancel extends AbstractDialog {
    constructor(message, title = '') { super(message, title); }
}
exports.DialogOkNoCancel = DialogOkNoCancel;
function Implement() {
}
exports.Implement = Implement;
//# sourceMappingURL=ModalDialog.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ivanlog/gs-com-modal_dialogs/index.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./ModalDialog */ "./node_modules/@ivanlog/gs-com-modal_dialogs/ModalDialog.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/com/BtnBoxes.js":
/*!**************************************************!*\
  !*** ./node_modules/@ivanlog/gs/com/BtnBoxes.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RadioBtns = exports.BtnsBox = exports.CheckBox = exports.ItemButton = void 0;
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
const WrapperGS_js_1 = __webpack_require__(/*! ../core/WrapperGS.js */ "./node_modules/@ivanlog/gs/core/WrapperGS.js");
class ItemButton extends WrapperGS_js_1.WrapperGS {
    constructor(el) {
        super(el);
    }
    get value() { return this.getData(ItemButton.TagDataValue); }
    set value(value) { this.setData(ItemButton.TagDataValue, value); }
    get selected() { return this.hasClass(ItemButton.TagClassSelectedState); }
    select() { this.addClass(ItemButton.TagClassSelectedState); }
    unselect() { this.removeClass(ItemButton.TagClassSelectedState); }
}
exports.ItemButton = ItemButton;
ItemButton.TagClassName = 'gs-item_btn';
ItemButton.TagClassSelectedState = 'selected';
ItemButton.TagDataValue = 'item_val';
class CheckBox extends WrapperGS_js_1.WrapperGS {
    constructor(el) {
        super(el);
        this._onItemSelectedToken = new gs.EventToken();
        this._onItemClickedToken = new gs.EventToken();
        this.onItemSelected = new gs.EventGS(this._onItemSelectedToken);
        this.onItemClicked = new gs.EventGS(this._onItemClickedToken);
        if (!this.hasClass(CheckBox.TagClassName))
            throw new Error("Trying create CheckBox from HTMLElement without specific class in classList");
        this.onclick = (e) => this.handlerClick(e);
    }
    unselectAll() { this.getItems().forEach((item) => item.unselect()); }
    selectByValue(val, invokeEvent = true) {
        this.getItems().where(i => i.value === val).forEach((i) => this.selectItem(i, invokeEvent));
    }
    get value() {
        return this.getSelectedItems().select((i) => i.value);
    }
    set value(value) {
        this.unselectAll();
        this.getItems().forEach(i => {
            if (!i.value)
                return;
            if (value.indexOf(i.value) < 0)
                return;
            i.select();
        });
    }
    getAllValues() {
        const result = new gs.ArrayGS();
        this.getItems().forEach((item) => { if (item.value)
            result.push(item.value); });
        return result;
    }
    getSelectedItem() { return this.getSelectedItems().first(); }
    getSelectedItems() { return this.getItems().where((i) => i.selected); }
    getItems() { return this.getChildren().select(c => gs.def.toType(c, ItemButton)); }
    getItemByValue(cbvalue) { return this.getItems().where((i) => i.value === cbvalue).first(); }
    //*Private*//
    handlerClick(e) {
        const item = gs.def.toType(gs.w(e.target), ItemButton);
        if (!item)
            return;
        if (item.selected)
            item.unselect();
        else
            this.selectItem(item, true);
        this._onItemClickedToken.invoke(item);
    }
    ;
    selectItem(item, invokeEvent = true) {
        if (item.selected)
            return;
        item.select();
        if (invokeEvent) {
            this._onItemSelectedToken.invoke(item);
            this.el.dispatchEvent(new Event('input'));
        }
    }
    ;
}
exports.CheckBox = CheckBox;
CheckBox.TagClassName = 'gs-checkbox';
class BtnsBox extends WrapperGS_js_1.WrapperGS {
    constructor(el) {
        super(el);
        this._onItemClickedToken = new gs.EventToken();
        this.onItemClicked = new gs.EventGS(this._onItemClickedToken);
        if (!this.hasClass(BtnsBox.TagClassName))
            throw new Error("Trying create BtnsBox from HTMLElement without specific class in classList");
        this.onclick = (e) => this.handlerClick(e);
    }
    getAllValues() {
        const result = new gs.ArrayGS();
        this.getItems().forEach((item) => { if (item.value)
            result.push(item.value); });
        return result;
    }
    getItems() { return this.getChildren().select(c => gs.def.toType(c, ItemButton)); }
    getItemByValue(cbvalue) { return this.getItems().where((i) => i.value === cbvalue).first(); }
    //*Private*//
    handlerClick(e) {
        const item = gs.def.toType(gs.w(e.target), ItemButton);
        if (!item)
            return;
        this._onItemClickedToken.invoke(item);
    }
    ;
}
exports.BtnsBox = BtnsBox;
BtnsBox.TagClassName = 'gs-btnsbox';
class RadioBtns extends WrapperGS_js_1.WrapperGS {
    constructor(el) {
        super(el);
        this._onItemSelectedToken = new gs.EventToken();
        this.onItemSelected = new gs.EventGS(this._onItemSelectedToken);
        if (!this.hasClass(RadioBtns.TagClassName))
            throw new Error("Trying create RadioBtns from HTMLElement without specific class in classList");
        this.onclick = (e) => this.handlerClick(e);
    }
    unselectAll() { this.getItems().forEach((item) => item.unselect()); }
    selectByValue(val, invokeEvent = true) {
        this.unselectAll();
        this.getItems().where(i => i.value === val).forEach((i) => this.selectItem(i, invokeEvent));
    }
    get value() { const item = this.getSelectedItem(); if (item)
        return item.value;
    else
        return undefined; }
    set value(value) { this.selectByValue(value); }
    getAllValues() {
        const result = new gs.ArrayGS();
        this.getItems().forEach((item) => { if (item.value)
            result.push(item.value); });
        return result;
    }
    getSelectedItem() { return this.getItems().where((i) => i.selected).first(); }
    getItems() { return this.getChildren().select(c => gs.def.toType(c, ItemButton)); }
    getItemByValue(cbvalue) { return this.getItems().where((i) => i.value === cbvalue).first(); }
    //*Private*//
    handlerClick(e) {
        const item = gs.def.toType(gs.w(e.target), ItemButton);
        if (!item)
            return;
        this.unselectAll();
        this.selectItem(item, true);
    }
    ;
    selectItem(item, invokeEvent = true) {
        if (item.selected)
            return;
        item.select();
        if (invokeEvent) {
            this._onItemSelectedToken.invoke(item);
            this.el.dispatchEvent(new Event('input'));
        }
    }
    ;
}
exports.RadioBtns = RadioBtns;
RadioBtns.TagClassName = 'gs-radiobtns';
gs.WrapperGS.ExtendComponentsByTagClass(ItemButton);
gs.WrapperGS.ExtendComponentsByTagClass(CheckBox);
gs.WrapperGS.ExtendComponentsByTagClass(BtnsBox);
gs.WrapperGS.ExtendComponentsByTagClass(RadioBtns);
//# sourceMappingURL=BtnBoxes.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/com/FormGS.js":
/*!************************************************!*\
  !*** ./node_modules/@ivanlog/gs/com/FormGS.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormGS = void 0;
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
const WrapperGS_js_1 = __webpack_require__(/*! ../core/WrapperGS.js */ "./node_modules/@ivanlog/gs/core/WrapperGS.js");
const core_1 = __webpack_require__(/*! ../core */ "./node_modules/@ivanlog/gs/core/index.js");
class FormGS extends WrapperGS_js_1.WrapperGS {
    constructor(el) {
        super(el);
        this._handlers = new gs.ArrayGS();
        this._firstTimeValidated = false;
        this.addEventHandler();
    }
    static ForHTMLElement(el) { return el.nodeName.toLowerCase() === "form"; }
    static AddExternalValidation(name, func) { this._ExternalFunc.set(name, func); }
    validAsync() {
        return __awaiter(this, void 0, void 0, function* () {
            this.addEventHandler();
            const valids = yield this._handlers.parallelAsync((w) => this.validFieldAsync(w.wrapper));
            const valid = valids.where(r => r === false).length === 0;
            return valid;
        });
    }
    fillFormData(data, withValidation = true) {
        return __awaiter(this, void 0, void 0, function* () {
            this.addEventHandler();
            for (const control of this._handlers) {
                const w = control.wrapper;
                const name = w.attr('name');
                if (!name)
                    continue;
                if (data[name] === undefined)
                    continue;
                const inputEl = gs.def.toType(w.el, HTMLInputElement);
                if (inputEl) {
                    if (inputEl.type === "radio") {
                        if (inputEl.value === gs.def.string(data[name]))
                            inputEl.checked = true;
                        continue;
                    }
                    if (inputEl.type === "checkbox") {
                        if (!Array.isArray(data[name]))
                            continue;
                        const array = new core_1.ArrayGS();
                        data[name].forEach(v => array.push(gs.def.string(v)));
                        if (!array.contains(inputEl.value))
                            continue;
                        inputEl.checked = true;
                        continue;
                    }
                }
                const valuedWr = WrapperGS_js_1.WrapperGS.ToValued(w);
                if (valuedWr) {
                    valuedWr.value = data[name];
                    continue;
                }
                const valuedAsyncWr = WrapperGS_js_1.WrapperGS.ToAsyncValued(w);
                if (valuedAsyncWr) {
                    yield valuedAsyncWr.setValueAsync(data[name]);
                    continue;
                }
                const any = w.el;
                if (any.value !== undefined)
                    any.value = data[name];
            }
            if (withValidation)
                this.getFormData();
        });
    }
    getFormData(evenNotValid = false) {
        return __awaiter(this, void 0, void 0, function* () {
            const valid = yield this.validAsync();
            if (!evenNotValid)
                if (!valid)
                    return undefined;
            const data = new Object();
            for (const control of this._handlers) {
                const w = control.wrapper;
                const name = w.attr('name');
                if (!name)
                    continue;
                const valuedWr = WrapperGS_js_1.WrapperGS.ToValued(w);
                if (valuedWr) {
                    data[name] = valuedWr.value;
                    continue;
                }
                const valuedAsyncWr = WrapperGS_js_1.WrapperGS.ToAsyncValued(w);
                if (valuedAsyncWr) {
                    data[name] = yield valuedAsyncWr.getValueAsync();
                    continue;
                }
                const inputEl = gs.def.toType(w.el, HTMLInputElement);
                if (inputEl) {
                    switch (inputEl.type) {
                        case "radio":
                            if (inputEl.checked)
                                data[name] = inputEl.value;
                            continue;
                        case "checkbox":
                            if (!inputEl.checked)
                                continue;
                            if (!data[name]) {
                                data[name] = new Array(0);
                            }
                            data[name].push(inputEl.value);
                            continue;
                    }
                }
                const valued = WrapperGS_js_1.WrapperGS.ToValued(w);
                if (valued)
                    data[name] = valued.value;
            }
            return data;
        });
    }
    destroy() {
        this._handlers.forEach(h => h.dispose());
        this._handlers.clear();
    }
    validFieldAsync(field) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!field)
                return undefined;
            if (!field.el.parentNode) {
                const handler = this._handlers.where(c => c.wrapper === field).first();
                if (!handler)
                    return undefined;
                handler.dispose();
                this._handlers.remove(handler);
                return undefined;
            }
            //Proccessing firstTimeValidation
            if (!this._firstTimeValidated) {
                /*   if (this.hasClass("needs-validation")) this.removeClass("needs-validation");
                   if (!this.hasClass("was-validated")) this.addClass("was-validated");*/
                this._firstTimeValidated = true;
                yield this.validAsync();
            }
            //Clear validation
            const fieldSetElement = gs.def.toType(field.el, HTMLFieldSetElement);
            if (fieldSetElement)
                fieldSetElement.setCustomValidity('');
            else {
                field.removeClass('is-valid');
                field.removeClass('is-invalid');
            }
            const rulesArg = field.attr('validrules');
            if (!rulesArg)
                return true;
            const rules = rulesArg.split(' ');
            const validErrors = [];
            const addError = (error) => {
                if (typeof error === "string") {
                    validErrors.push(error);
                    return true;
                }
                return false;
            };
            for (const ruleRecord of rules) {
                let rule;
                let ruleArg;
                if (ruleRecord.indexOf("=") >= 0) {
                    const parser = ruleRecord.split("=");
                    rule = parser[0].toLowerCase();
                    ruleArg = parser[1];
                }
                else
                    rule = ruleRecord.toLowerCase();
                if (rule === 'external') {
                    if (!FormGS._ExternalFunc.has(ruleArg)) {
                        addError("Не найдена функция валидации");
                        continue;
                    }
                    const validationFunction = FormGS._ExternalFunc.get(ruleArg);
                    addError(validationFunction(field));
                    continue;
                }
                const validable = WrapperGS_js_1.WrapperGS.ToValidable(field);
                if (validable) {
                    addError(validable.valid(rule, ruleArg));
                    continue;
                }
                const validableAsync = WrapperGS_js_1.WrapperGS.ToAsyncValidable(field);
                if (validableAsync) {
                    addError(yield validableAsync.validAsync(rule, ruleArg));
                    continue;
                }
                const valued = WrapperGS_js_1.WrapperGS.ToValued(field);
                if (!valued) {
                    if (rule !== 'req')
                        continue;
                    //{ addError("Объект не имеет значения для валидации"); continue; }
                }
                let anotherControl;
                let anotherValued;
                switch (rule) {
                    case 'req':
                        addError(gs.validation.valueRequired(valued));
                        break;
                    case 'number':
                    case 'numbers':
                        addError(gs.validation.valueIsNumber(valued));
                        break;
                    case 'max':
                        addError(gs.validation.valueNumberMax(valued, parseFloat(ruleArg)));
                        break;
                    case 'min':
                        addError(gs.validation.valueNumberMin(valued, parseFloat(ruleArg)));
                        break;
                    case 'uint':
                        addError(gs.validation.valueNumberUInt(valued));
                        break;
                    case 'int':
                        addError(gs.validation.valueNumberInt(valued));
                        break;
                    case 'notonlynumbers':
                        addError(gs.validation.valueNotNumber(valued));
                        break;
                    case 'length':
                        addError(gs.validation.valueLength(valued, parseInt(ruleArg)));
                        break;
                    case 'minlength':
                        addError(gs.validation.valueMinLength(valued, parseInt(ruleArg)));
                        break;
                    case 'maxlength':
                        addError(gs.validation.valueMaxLength(valued, parseInt(ruleArg)));
                        break;
                    case 'phone':
                        addError(gs.validation.valueIsPhone(valued));
                        break;
                    case 'email':
                        addError(gs.validation.valueIsEmail(valued));
                        break;
                    case 'same':
                        anotherControl = this._handlers.where(i => i.wrapper.attr('name') === ruleArg).first();
                        anotherValued = WrapperGS_js_1.WrapperGS.ToValued(anotherControl.wrapper);
                        if (!anotherValued)
                            addError("Не найдено поле для сравнения");
                        else
                            addError(gs.validation.valueSame(valued, anotherControl.wrapper));
                        break;
                    case 'samebyid':
                        anotherControl = this._handlers.where(i => i.wrapper.attr('id') === ruleArg).first();
                        anotherValued = WrapperGS_js_1.WrapperGS.ToValued(anotherControl.wrapper);
                        if (!anotherValued)
                            addError("Не найдено поле для сравнения");
                        else
                            addError(gs.validation.valueSame(valued, anotherControl.wrapper));
                        break;
                }
            }
            const errorsText = validErrors.join('\r\n');
            //Если есть встроенные возможности, используем
            if (fieldSetElement)
                fieldSetElement.setCustomValidity(errorsText);
            else {
                if (!errorsText)
                    gs.w(field).addClass('is-valid');
                else
                    gs.w(field).addClass('is-invalid');
            }
            //Находим если есть контейнер для ошибок и выводим туда сообщение
            const parent = gs.w(field.el.parentNode);
            const errorContainer = parent.q('.invalid-feedback').first;
            if (errorContainer)
                errorContainer.text = errorsText;
            return validErrors.length === 0;
        });
    }
    addEventHandler() {
        this.q('input, textarea').forEach(i => { this.linkControl(i); });
        this.q(FormGS.TagInputListen).forEach(i => { this.linkControl(i); });
    }
    linkControl(wr) {
        //check exists
        if (this._handlers.where(l => l.wrapper === wr).length > 0)
            return;
        const handler = (e) => {
            const wr = gs.w(e.target);
            if (wr)
                this.validFieldAsync(wr);
        };
        this._handlers.push(new core_1.EventHandlerDisposable(wr, "input", handler));
    }
}
exports.FormGS = FormGS;
FormGS.TagClassName = 'gs-form';
/**Each wrapper with this class FormGS will be listen on 'input' Event for validation and data collection*/
FormGS.TagInputListen = 'gs-form-input';
FormGS._ExternalFunc = new Map();
gs.WrapperGS.ExtendComponentsByTagClass(FormGS);
gs.WrapperGS.ExtendComponentsByHTMLElement(FormGS);
//# sourceMappingURL=FormGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/com/ImageGS.js":
/*!*************************************************!*\
  !*** ./node_modules/@ivanlog/gs/com/ImageGS.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImageGS = void 0;
const WrapperGS_1 = __webpack_require__(/*! ../core/WrapperGS */ "./node_modules/@ivanlog/gs/core/WrapperGS.js");
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
class ImageGS extends WrapperGS_1.WrapperGS {
    constructor(el) {
        super(el);
        this._onLoadedToken = new gs.EventToken(() => { el.addEventListener('load', () => this._onLoadedToken.invoke()); });
        this.onLoaded = new gs.EventGS(this._onLoadedToken);
    }
    static ForHTMLElement(el) { return el.nodeName.toLowerCase() === "img"; }
    get src() { return this.el.src; }
    set src(value) { this.el.src = value; }
}
exports.ImageGS = ImageGS;
gs.WrapperGS.ExtendComponentsByHTMLElement(ImageGS);
//# sourceMappingURL=ImageGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/com/InputFilesGS.js":
/*!******************************************************!*\
  !*** ./node_modules/@ivanlog/gs/com/InputFilesGS.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InputFilesGS = void 0;
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
const InputGS_1 = __webpack_require__(/*! ./InputGS */ "./node_modules/@ivanlog/gs/com/InputGS.js");
class InputFilesGS extends InputGS_1.InputGS {
    constructor(el) {
        super(el);
        this._onFilesSelectedToken = new gs.EventToken(() => { el.addEventListener('change', () => this.onChangeHandler()); });
        this.onFilesSelected = new gs.EventGS(this._onFilesSelectedToken);
    }
    static ForHTMLElement(el) {
        if (el.nodeName.toLowerCase() === "input") {
            const inputEl = el;
            return inputEl.type === 'file';
        }
        return false;
    }
    /**
     * Open selectFilesDialog
     * */
    open() {
        this.el.click();
    }
    onChangeHandler() {
        if (this.el.files.length === 0)
            return;
        const list = gs.ArrayGS.from(this.el.files);
        this._onFilesSelectedToken.invoke(list);
    }
}
exports.InputFilesGS = InputFilesGS;
gs.WrapperGS.ExtendComponentsByHTMLElement(InputFilesGS);
//# sourceMappingURL=InputFilesGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/com/InputGS.js":
/*!*************************************************!*\
  !*** ./node_modules/@ivanlog/gs/com/InputGS.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InputGS = void 0;
const gs = __webpack_require__(/*! ../index */ "./node_modules/@ivanlog/gs/index.js");
class InputGS extends gs.WrapperGS {
    static ForHTMLElement(el) {
        if (el.nodeName.toLowerCase() === "input") {
            const inputEl = el;
            return inputEl.type !== 'file';
        }
        return false;
    }
    constructor(el) {
        super(el);
    }
    get value() { return this.el.value; }
    set value(value) { this.el.value = value; }
}
exports.InputGS = InputGS;
gs.WrapperGS.ExtendComponentsByHTMLElement(InputGS);
//# sourceMappingURL=InputGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/com/TextAreaGS.js":
/*!****************************************************!*\
  !*** ./node_modules/@ivanlog/gs/com/TextAreaGS.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextAreaGS = void 0;
const gs = __webpack_require__(/*! ../index */ "./node_modules/@ivanlog/gs/index.js");
class TextAreaGS extends gs.WrapperGS {
    static ForHTMLElement(el) {
        return el.nodeName.toLowerCase() === "textarea";
    }
    constructor(el) {
        super(el);
    }
    get value() { return this.el.value; }
    set value(value) { this.el.value = value; }
}
exports.TextAreaGS = TextAreaGS;
gs.WrapperGS.ExtendComponentsByHTMLElement(TextAreaGS);
//# sourceMappingURL=TextAreaGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/com/index.js":
/*!***********************************************!*\
  !*** ./node_modules/@ivanlog/gs/com/index.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./BtnBoxes */ "./node_modules/@ivanlog/gs/com/BtnBoxes.js"), exports);
__exportStar(__webpack_require__(/*! ./FormGS */ "./node_modules/@ivanlog/gs/com/FormGS.js"), exports);
__exportStar(__webpack_require__(/*! ./ImageGS */ "./node_modules/@ivanlog/gs/com/ImageGS.js"), exports);
__exportStar(__webpack_require__(/*! ./InputGS */ "./node_modules/@ivanlog/gs/com/InputGS.js"), exports);
__exportStar(__webpack_require__(/*! ./InputFilesGS */ "./node_modules/@ivanlog/gs/com/InputFilesGS.js"), exports);
__exportStar(__webpack_require__(/*! ./TextAreaGS */ "./node_modules/@ivanlog/gs/com/TextAreaGS.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/ArrayGS.js":
/*!**************************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/ArrayGS.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, exports) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ArrayGS = void 0;
class ArrayGS extends Array {
    static from(iterable) {
        const result = new ArrayGS();
        result.addRange(Array.from(iterable));
        return result;
    }
    constructor(...args) {
        super(...args);
    }
    clear() { this.splice(0, this.length); }
    remove(item) { const index = this.indexOf(item); if (index > -1)
        this.splice(index, 1); }
    first() { if (this.length === 0)
        return undefined; return this[0]; }
    last() { if (this.length === 0)
        return undefined; return this[this.length - 1]; }
    clone() { const result = new ArrayGS(); result.addRange(this); return result; }
    /**
     * @param func
     * @param exceptUndefined default:true
     */
    select(func, exceptUndefined = true) {
        const result = new ArrayGS();
        for (let item of this) {
            const r = func(item);
            if (exceptUndefined)
                if (r === undefined)
                    continue;
            result.push(r);
        }
        return result;
    }
    /**
     * @param func
     * @param exceptUndefined default:true
     */
    parallelAsync(func, exceptUndefined = true) {
        return __awaiter(this, void 0, void 0, function* () {
            const promises = new ArrayGS();
            for (const item of this)
                promises.push(func(item));
            const results = yield Promise.all(promises);
            if (exceptUndefined)
                return ArrayGS.from(results).where(r => r !== undefined);
            else
                return ArrayGS.from(results);
        });
    }
    where(func) {
        const result = new ArrayGS();
        for (let item of this) {
            if (func(item))
                result.push(item);
        }
        return result;
    }
    take(count) {
        const result = new ArrayGS();
        let i = 0;
        for (let item of this) {
            i++;
            if (i > count)
                break;
            result.push(item);
        }
        return result;
    }
    skip(count) {
        const result = new ArrayGS();
        let i = 0;
        for (let item of this) {
            i++;
            if (i <= count)
                continue;
            result.push(item);
        }
        return result;
    }
    contains(item) { return this.indexOf(item) > -1; }
    addRange(array) { array.forEach(item => { this.push(item); }); }
}
exports.ArrayGS = ArrayGS;
//# sourceMappingURL=ArrayGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/ComponentGS.js":
/*!******************************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/ComponentGS.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentGS = void 0;
const TemplateGS_1 = __webpack_require__(/*! ./TemplateGS */ "./node_modules/@ivanlog/gs/core/TemplateGS.js");
/**Use like superclass for components created from generated templates*/
class ComponentGS extends TemplateGS_1.TemplateGS {
    constructor(nameOrEl, ctrlConstructor) {
        super(nameOrEl);
        this.ctrls = new ctrlConstructor(this._controls);
    }
}
exports.ComponentGS = ComponentGS;
//# sourceMappingURL=ComponentGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/Enums.js":
/*!************************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/Enums.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Types = void 0;
var Types;
(function (Types) {
    Types["Bool"] = "boolean";
    Types["Function"] = "function";
    Types["Number"] = "number";
    Types["BigInt"] = "bigint";
    Types["Object"] = "object";
    Types["String"] = "string";
    Types["Symbol"] = "symbol";
    Types["Undefined"] = "undefined";
    /**Type is one of 'boolean|number|bigint|object|string|symbol' */
    Types["NotFunction"] = "notfunction";
})(Types = exports.Types || (exports.Types = {}));
//# sourceMappingURL=Enums.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/EventsGS.js":
/*!***************************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/EventsGS.js ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventAsyncGS = exports.EventGS = exports.EventAsyncToken = exports.EventToken = exports.EventHandlerDisposable = void 0;
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
class EventHandlerDisposable {
    constructor(wrapper, event, eventHandler) {
        this.wrapper = wrapper;
        this.event = event;
        this.eventHandler = eventHandler;
        this.wrapper.el.addEventListener(event, eventHandler);
    }
    dispose() { this.wrapper.el.removeEventListener(this.event, this.eventHandler); }
}
exports.EventHandlerDisposable = EventHandlerDisposable;
/**Return private invoke function ouside to initializer*/
class EventToken {
    /**
     * @param hasHandlersCallback  Invoke then event add first handler. Use for assign pipe listeners only when it need (another one start listen)
     */
    constructor(hasHandlersCallback) {
        this._hasHandlersCallback = hasHandlersCallback;
    }
    /** Invoke then event add first handler. Use for assign pipe listeners only when it need (another one start listen)*/
    get hasHandlersCallback() { return this._hasHandlersCallback; }
}
exports.EventToken = EventToken;
/**Return private invoke function ouside to initializer*/
class EventAsyncToken {
    /**
    * @param hasHandlersCallback  Invoke then event add first handler. Use for assign pipe listeners only when it need (another one start listen)
    */
    constructor(hasHandlersCallback) {
        this._hasHandlersCallback = hasHandlersCallback;
    }
    /** Invoke then event add first handler. Use for assign pipe listeners only when it need (another one start listen)*/
    get hasHandlersCallback() { return this._hasHandlersCallback; }
}
exports.EventAsyncToken = EventAsyncToken;
class EventGS {
    constructor(token) {
        this._handlers = new gs.ArrayGS();
        this._handlersOnce = new gs.ArrayGS();
        this._token = token;
        this._token.invoke = (e) => this.invoke(e);
    }
    addHandler(listener) {
        this.checkFirstHandler();
        this._handlers.push(listener);
        return { dispose: () => this.removeHandler(listener) };
    }
    addOnceHandler(listener) {
        this.checkFirstHandler();
        this._handlersOnce.push(listener);
        return { dispose: () => this.removeHandler(listener) };
    }
    removeHandler(handler) {
        this._handlers.remove(handler);
        this._handlersOnce.remove(handler);
    }
    invoke(event) {
        this._handlers.forEach((l) => l(event));
        const onceList = this._handlersOnce.clone();
        this._handlersOnce.clear();
        onceList.forEach((l) => l(event));
    }
    checkFirstHandler() {
        if (this._handlers.length === 0 && this._handlersOnce.length === 0)
            if (this._token.hasHandlersCallback)
                this._token.hasHandlersCallback();
    }
}
exports.EventGS = EventGS;
class EventAsyncGS {
    constructor(token) {
        this._handlers = new gs.ArrayGS();
        this._handlersOnce = new gs.ArrayGS();
        this._token = token;
        this._token.invoke = (e) => __awaiter(this, void 0, void 0, function* () { return yield this.invokeAsync(e); });
    }
    addHandler(listener) {
        this.checkFirstHandler();
        this._handlers.push(listener);
        return { dispose: () => this.removeHandler(listener) };
    }
    addOnceHandler(listener) {
        this.checkFirstHandler();
        this._handlersOnce.push(listener);
        return { dispose: () => this.removeHandler(listener) };
    }
    removeHandler(handler) {
        this._handlers.remove(handler);
        this._handlersOnce.remove(handler);
    }
    invokeAsync(event) {
        return __awaiter(this, void 0, void 0, function* () {
            for (const handler of this._handlers)
                yield handler(event);
            const onceList = this._handlersOnce.clone();
            this._handlersOnce.clear();
            for (const handler of onceList)
                yield handler(event);
        });
    }
    checkFirstHandler() {
        if (this._handlers.length === 0 && this._handlersOnce.length === 0)
            if (this._token.hasHandlersCallback)
                this._token.hasHandlersCallback();
    }
}
exports.EventAsyncGS = EventAsyncGS;
//# sourceMappingURL=EventsGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/GS.js":
/*!*********************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/GS.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GS = void 0;
const ArrayGS_1 = __webpack_require__(/*! ./ArrayGS */ "./node_modules/@ivanlog/gs/core/ArrayGS.js");
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
class GS {
    constructor(selector, inElement) {
        const type = typeof (selector);
        this._all = new ArrayGS_1.ArrayGS();
        const tAll = this._all;
        function savePush(e) { const wr = gs.w(e); if (wr)
            tAll.push(wr); }
        switch (type) {
            case 'string':
                if (inElement)
                    inElement.querySelectorAll(selector).forEach(e => savePush(e));
                else
                    document.querySelectorAll(selector).forEach(e => savePush(e));
                break;
            case 'object':
                savePush(selector);
                break;
        }
    }
    static Extend() {
    }
    static Query(selector) { return new GS(selector); }
    get el() { return this.first.el; }
    get els() { return this._all.select(s => s.el); }
    get all() { return this._all.clone(); }
    get first() { return this._all.first(); }
    get last() { return this._all.last(); }
    forEach(callbackfn, thisArg) { this.all.forEach(callbackfn, thisArg); }
    text(value) { this.forEach(w => w.text = value); }
    html(value) { this.forEach(w => w.html = value); }
    /**
     * @param {any} el
     */
    append(el) { if (this.first)
        this.first.append(el); }
    hide() { this.forEach(w => w.hide()); }
    show() { this.forEach(w => w.show()); }
    showflip() { this.forEach(w => w.showflip()); }
    enable() { this.forEach(w => w.enable()); }
    disable() { this.forEach(w => w.disable()); }
    /**
     * @param {string} className
     */
    addClass(className) { this.forEach(i => i.addClass(className)); }
    ;
    /**
     * @param {string} className
     */
    removeClass(className) { this.forEach(i => i.removeClass(className)); }
    ;
    cut() { this.forEach(i => i.cut()); }
    ;
}
exports.GS = GS;
//# sourceMappingURL=GS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/StateGS.js":
/*!**************************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/StateGS.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StateGS = exports.StateRunResultEnum = void 0;
const gs = __webpack_require__(/*! ../ */ "./node_modules/@ivanlog/gs/index.js");
var StateRunResultEnum;
(function (StateRunResultEnum) {
    /**State successfull activated  */
    StateRunResultEnum[StateRunResultEnum["Activated"] = 0] = "Activated";
    /**State activation failed */
    StateRunResultEnum[StateRunResultEnum["Failed"] = 1] = "Failed";
    /**State activation failed, but instead of this state was activated another*/
    StateRunResultEnum[StateRunResultEnum["Skipped"] = 2] = "Skipped";
})(StateRunResultEnum = exports.StateRunResultEnum || (exports.StateRunResultEnum = {}));
class StateGS {
    constructor(title, inHistory = true) {
        this._urlArgs = {};
        this._active = false;
        if (!StateGS._Inited)
            StateGS.Initialize();
        this.title = title;
        this.inHistory = inHistory;
        this._active = false;
    }
    static Initialize() {
        StateGS.UrlPathName = window.location.pathname.toLowerCase();
        StateGS.UrlFullPath = window.location.origin.toLowerCase() + StateGS.UrlPathName;
        window.onpopstate = (e) => StateGS.RunByUrl(e, false);
    }
    static Run(constructor, args, withHistory = true) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!constructor)
                return StateRunResultEnum.Failed;
            const state = new constructor();
            state._name = constructor.StateName;
            //Try activate new state
            const activeResult = yield state.start(args);
            if (activeResult !== StateRunResultEnum.Activated)
                return activeResult;
            //Set and show new state
            if (withHistory)
                if (state.inHistory) {
                    const stateStatus = {};
                    stateStatus[StateGS.UrlStateArgName] = state.name;
                    if (state.name.toLocaleLowerCase() !== StateGS.DefaultStateName.toLocaleLowerCase())
                        history.pushState(stateStatus, state.title, state.getUrlArgs());
                    else
                        history.pushState(stateStatus, state.title, StateGS.UrlPathName);
                }
            document.title = state.title;
            StateGS.CatchLinks();
            window.scrollTo(0, 0);
            return StateRunResultEnum.Activated;
        });
    }
    static RunInstance(state, withHistory = true) {
        return __awaiter(this, void 0, void 0, function* () {
            //Try activate new state
            const activeResult = yield state.start();
            if (activeResult !== StateRunResultEnum.Activated)
                return activeResult;
            //Set and show new state
            if (withHistory)
                if (state.inHistory) {
                    const stateStatus = {};
                    stateStatus[StateGS.UrlStateArgName] = state.name;
                    if (state.name.toLocaleLowerCase() !== StateGS.DefaultStateName.toLocaleLowerCase())
                        history.pushState(stateStatus, state.title, state.getUrlArgs());
                    else
                        history.pushState(stateStatus, state.title, StateGS.UrlPathName);
                }
            document.title = state.title;
            StateGS.CatchLinks();
            window.scrollTo(0, 0);
            return StateRunResultEnum.Activated;
        });
    }
    static RunByUrl(e, withHistory = true) {
        return __awaiter(this, void 0, void 0, function* () { return yield StateGS.RunByUrlArgs(gs.web.getUrlArgs(), window.location.search, e, withHistory); });
    }
    static RunByUrlArgs(args, search, event, withHistory = true) {
        return __awaiter(this, void 0, void 0, function* () {
            let stateName = args[StateGS.UrlStateArgName];
            if (!stateName)
                if (search === '')
                    stateName = StateGS.DefaultStateName;
                else
                    return StateRunResultEnum.Failed;
            const state = StateGS._RegStates.get(stateName.toLowerCase());
            if (!state)
                return StateRunResultEnum.Failed;
            if (event)
                gs.events.stop(event);
            let result;
            try {
                result = yield StateGS.Run(state, args, withHistory);
            }
            catch (exc) {
                console.error(exc);
                return StateRunResultEnum.Failed;
            }
            return result;
        });
    }
    static RegState(constructor) { this._RegStates.set(constructor.StateName.toLowerCase(), constructor); }
    static get ActiveState() { return StateGS._ActiveState; }
    get name() { return this._name; }
    get title() { return this._title; }
    set title(value) { this._title = value; }
    get isActive() { return this._active; }
    stop() {
        return __awaiter(this, void 0, void 0, function* () { this._active = false; });
    }
    start(args) {
        return __awaiter(this, void 0, void 0, function* () {
            this._active = true;
            const wasState = StateGS._ActiveState;
            StateGS._ActiveState = this;
            if (wasState)
                yield wasState.stop();
            yield this.afterStart(args);
            return StateRunResultEnum.Activated;
        });
    }
    afterStart(args) {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    updateUrl() {
        if (!this.inHistory)
            throw new Error("Can't update url. State not in history.");
        const stateStatus = {};
        stateStatus[StateGS.UrlStateArgName] = this.name;
        if (this.name.toLocaleLowerCase() !== StateGS.DefaultStateName.toLocaleLowerCase())
            history.pushState(stateStatus, this.title, this.getUrlArgs());
        else
            history.pushState(stateStatus, this.title, StateGS.UrlPathName);
    }
    getUrlArgs() {
        const args = [];
        for (const key in this._urlArgs)
            args.push(`${key}=${this._urlArgs[key]}`);
        if (args.length === 0)
            return `?${StateGS.UrlStateArgName}=${this.name}`;
        else
            return `?${StateGS.UrlStateArgName}=${this.name}&${args.join("&")}`;
    }
    static CatchLinks() {
        gs.q('a').all.where(l => !l.hasClass(StateGS.LinkCatchedClassName)).forEach(link => this._CatchLink(link));
    }
    static _CatchLink(wr) {
        const a = gs.def.toType(wr.el, HTMLAnchorElement);
        if (!a)
            return;
        wr.addClass(StateGS.LinkCatchedClassName);
        if (!a.href)
            return;
        wr.onclick = (e) => __awaiter(this, void 0, void 0, function* () {
            if (!a.origin)
                return;
            const fPath = a.origin.toLowerCase() + a.pathname.toLowerCase();
            if (fPath !== StateGS.UrlFullPath)
                return;
            const args = gs.web.parseUrlArgs(a.href);
            yield StateGS.RunByUrlArgs(args, a.search, e);
            gs.events.stop(e);
        });
    }
}
exports.StateGS = StateGS;
StateGS._Inited = false;
StateGS._RegStates = new Map();
StateGS.LinkCatchedClassName = "states-catched";
StateGS.UrlPathName = "";
StateGS.UrlFullPath = "";
StateGS.UrlStateArgName = "state";
StateGS.DefaultStateName = "main";
//# sourceMappingURL=StateGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/TemplateGS.js":
/*!*****************************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/TemplateGS.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TemplateGS = void 0;
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
const WrapperGS_1 = __webpack_require__(/*! ./WrapperGS */ "./node_modules/@ivanlog/gs/core/WrapperGS.js");
/**
 * Шаблон имеющий data-tmpl-name (TagDataTemplateName) доступен для создания по имени. Шаблоны без имени могут быть созданы только передачей эталонного элемента в конструктор
 * Все шаблоны тега template - шаблон верхнего уровня.
 * Допускается создавать шаблоны вложенные в другие шаблоны.
 * Вложенные шаблоны - любога тега кроме template, при заполнении попадают в controls.
 * Вложенные шаблоны верхнего уровня будут удаляться при заполнении шаблона. Но они будут доступны к созданию по имени.
 * Если нужно поменять конечный тег для тега template используем data-tmpl-tag(TagDataTemplateTag).
 * */
class TemplateGS extends WrapperGS_1.WrapperGS {
    constructor(nameOrEl) {
        let name;
        let wr;
        //getting template wrapper
        if (typeof nameOrEl === 'string') {
            name = nameOrEl.toLowerCase();
            wr = gs.q('template').all.where((w) => { return (w.getGSA(TemplateGS.TagGSATemplateName).toLowerCase() === name); }).first();
            if (!wr)
                wr = gs.q('.' + WrapperGS_1.WrapperGS.ClassNameTemplate).all.where((w) => { return (w.getGSA(TemplateGS.TagGSATemplateName).toLowerCase() === name); }).first();
            if (!wr)
                throw new Error(`Cant create template with name ${nameOrEl}!`);
        }
        else {
            wr = gs.w(nameOrEl, true);
        }
        //getting template tag arguments
        const attrsMap = wr.getAttrsObj();
        if (attrsMap.has('id'))
            attrsMap.delete('id');
        const attrs = {};
        for (const k of attrsMap.keys()) {
            attrs[k] = attrsMap.get(k);
        }
        //getting target tag 
        let tagName = wr.el.tagName.toLowerCase();
        const needSetTag = wr.getGSA(TemplateGS.TagGSATemplateTag);
        if (needSetTag)
            tagName = needSetTag;
        //creating new Element
        let el;
        if (tagName === "template")
            el = gs.html.div(attrs, wr.html);
        else
            el = gs.html.tag(tagName, attrs, wr.html);
        super(el);
        this._controls = new Map();
        /**for collecting focusGroups */
        //const focusGroups: Map<string, FocusGroupGS> = new Map<string, FocusGroupGS>();
        /**Fill element */
        const fillData = (wr) => {
            const el = wr.el;
            //If it's top-level template, remove it
            if (wr.el.tagName.toLowerCase() === "template") {
                wr.cut();
                return;
            }
            let controlName = wr.getGSA(TemplateGS.TagGSAControlName);
            if (wr === this)
                controlName = undefined; //Контроль на сам шаблон может быть только во вложенности, а значит на root объекте его быть не может
            if (controlName)
                this._controls.set(controlName, wr);
            //Check - is it template
            const tmplName = wr.getGSA(TemplateGS.TagGSATemplateName);
            if (tmplName)
                //It's nested template
                if (this !== wr) {
                    const constructFunc = TemplateGS.Constructors.get(tmplName);
                    if (!constructFunc)
                        return;
                    const newW = constructFunc(tmplName);
                    wr.replace(newW);
                    if (controlName) {
                        this._controls.delete(controlName);
                        this._controls.set(controlName, newW);
                    }
                    return;
                }
            //Рекурсивный обход для не вложенных шаблонов
            wr.getChildren().forEach(c => fillData(c));
        };
        this.q('*'); //преобертка, чтобы была последовательная инициализация
        fillData(this);
        this.q('template').cut();
    }
    getControl(controlName) {
        return this._controls.get(controlName);
    }
    get tmplName() { return this.getGSA(TemplateGS.TagGSATemplateName); }
}
exports.TemplateGS = TemplateGS;
TemplateGS.TagGSATemplateName = 'tmpl';
TemplateGS.TagGSATemplateTag = 'tmpl-tag';
TemplateGS.TagGSAControlName = 'ctrl';
//Содержит типизированные конструкторы. Заполняется ими из кодосгенерированной части шаблонов.
TemplateGS.Constructors = new Map();
//# sourceMappingURL=TemplateGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/WrapperGS.js":
/*!****************************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/WrapperGS.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WrapperGS = void 0;
const gs = __webpack_require__(/*! ../ */ "./node_modules/@ivanlog/gs/index.js");
const ArrayGS_js_1 = __webpack_require__(/*! ./ArrayGS.js */ "./node_modules/@ivanlog/gs/core/ArrayGS.js");
const GS_js_1 = __webpack_require__(/*! ./GS.js */ "./node_modules/@ivanlog/gs/core/GS.js");
class WrapperGS {
    constructor(el) {
        const wr = this;
        this.el = el;
        if (this.el[WrapperGS.NameOfInstInPropOfEl])
            return this.el[WrapperGS.NameOfInstInPropOfEl];
        this.el[WrapperGS.NameOfInstInPropOfEl] = this;
        ///Processing extends initDataArgs
        for (const key of WrapperGS._ImplementWrapperByGSA.keys()) {
            if (!this.getGSA(key))
                continue;
            WrapperGS._ImplementWrapperByGSA.get(key)(this);
        }
        ///Processing extends initClassArgs
        this.el.classList.forEach((cl) => {
            if (!cl)
                return;
            if (WrapperGS._ImplementWrapperByClassArg.has(cl))
                WrapperGS._ImplementWrapperByClassArg.get(cl)(wr);
        });
    }
    static ToValued(wr) {
        if (!gs.def.hasProp(wr, "value", gs.Types.NotFunction))
            return undefined;
        return wr;
    }
    static ToAsyncValued(wr) {
        if (!gs.def.hasProp(wr, "setValueAsync", gs.Types.Function))
            return undefined;
        if (!gs.def.hasProp(wr, "getValueAsync", gs.Types.Function))
            return undefined;
        return wr;
    }
    static ToSelectable(wr) {
        if (!gs.def.hasProp(wr, "selected", gs.Types.Bool))
            return undefined;
        if (!gs.def.hasProp(wr, "select", gs.Types.Function))
            return undefined;
        if (!gs.def.hasProp(wr, "unselect", gs.Types.Function))
            return undefined;
        return wr;
    }
    static ToValidable(wr) {
        if (!gs.def.hasProp(wr, "valid", gs.Types.Function))
            return undefined;
        return wr;
    }
    static ToAsyncValidable(wr) {
        if (!gs.def.hasProp(wr, "validAsync", gs.Types.Function))
            return undefined;
        return wr;
    }
    static InjectComponents(component, fullNameForTmplFile) {
        if (WrapperGS._InjectComponents.has(fullNameForTmplFile))
            throw new Error(`Component with fullName '${fullNameForTmplFile}' dublicated!`);
        WrapperGS._InjectComponents.set(fullNameForTmplFile, component);
    }
    static ReInjectComponents(fullNameForTmplFile) {
        WrapperGS._InjectComponents.delete(fullNameForTmplFile);
    }
    static ExtendComponentsByTagClass(component) {
        if (WrapperGS._ExtendComponentsByTagClass.has(component.TagClassName))
            throw new Error(`Component TagClass '${component.TagClassName}' dublicated!`);
        WrapperGS._ExtendComponentsByTagClass.set(component.TagClassName, component);
    }
    /**Return all tagClasses which extends components */
    static GetExtendComponentsTagClasses() { return ArrayGS_js_1.ArrayGS.from(WrapperGS._ExtendComponentsByTagClass.keys()); }
    static ExtendComponentsByHTMLElement(component) {
        WrapperGS._ExtendComponentsByHTMLElement.push(component);
    }
    static ReduceComponentsByHTMLElement(component) {
        WrapperGS._ExtendComponentsByHTMLElement.remove(component);
    }
    /**
     * Call linked function for each wrapper who has specific dataArg
     * @param dataArg
     * @param func (wr:Wrapper affected, rootWr:Wrapper of template)
     */
    static ImplementWrapperByGSA(gsa, func) {
        WrapperGS._ImplementWrapperByGSA.set(gsa, func);
    }
    /**
     * Call linked function for each wrapper who has specific dataArg
     * @param dataArg
     * @param func (wr:Wrapper affected, rootWr:Wrapper of template)
     */
    static ImplementWrapperByClassArg(classArg, func) {
        WrapperGS._ImplementWrapperByClassArg.set(classArg, func);
    }
    static get NameOfInstInPropOfEl() { return 'z_gswrapper_inst'; }
    static IsWrapper(el) { return el instanceof WrapperGS; }
    /**
     * Wrap element in WrapperGs
     * @param el
     * @param asTmpl Skip specializing for element and wrap raw Element
     */
    static Wrap(el, asTmpl = false) {
        if (WrapperGS.IsWrapper(el))
            return el;
        if (el.nodeType !== 1)
            return;
        if (el[WrapperGS.NameOfInstInPropOfEl])
            return el[WrapperGS.NameOfInstInPropOfEl];
        const htmlEl = el;
        if (asTmpl || htmlEl.tagName.toLocaleLowerCase() === "template" || htmlEl.classList.contains("template"))
            return new WrapperGS(el);
        //replacing element if has component
        const cmpName = htmlEl.getAttribute('data-' + WrapperGS.AttrDataComponentInject);
        if (cmpName)
            if (WrapperGS._InjectComponents.has(cmpName)) {
                const c = WrapperGS._InjectComponents.get(cmpName);
                const cArgs = htmlEl.getAttribute('data-' + WrapperGS.AttrDataComponentInjectArgs);
                let cmp;
                if (cArgs)
                    cmp = new c(JSON.parse(cArgs));
                else
                    cmp = new c();
                if (htmlEl.parentNode) {
                    htmlEl.after(cmp.el);
                    htmlEl.parentNode.removeChild(htmlEl);
                }
            }
        //wrapping extendsByTagClass
        for (const key of WrapperGS._ExtendComponentsByTagClass.keys())
            if (htmlEl.classList.contains(key)) {
                const c = WrapperGS._ExtendComponentsByTagClass.get(key);
                return new c(htmlEl);
            }
        //wrapping extendsByHTMLElementValidationFunc
        for (const c of WrapperGS._ExtendComponentsByHTMLElement)
            if (c.ForHTMLElement(htmlEl))
                return new c(htmlEl);
        return new WrapperGS(el);
    }
    get isEnabled() { return !this.hasClass("disabled"); }
    get isShowed() { return !this.hasClass("d-none"); }
    q(selector) { return new GS_js_1.GS(selector, this.el); }
    hasClass(className) { if (!this.el.classList)
        return false; return this.el.classList.contains(className); }
    addClass(className) { if (!this.el.classList)
        return; if (!this.hasClass(className))
        this.el.classList.add(className); }
    addClasses(classesNames) { for (const c of classesNames)
        this.addClass(c); }
    removeClass(className) { if (!this.el.classList)
        return; if (this.hasClass(className))
        this.el.classList.remove(className); }
    flipClass(className) { if (!this.el.classList)
        return; if (this.hasClass(className))
        this.el.classList.remove(className);
    else
        this.el.classList.add(className); }
    getElement(el) {
        if (WrapperGS.IsWrapper(el))
            return el.el;
        else
            return el;
    }
    /**Add after this wrapper*/
    after(el) { this.el.after(this.getElement(el)); }
    /**Add before this wrapper*/
    before(el) { this.el.before(this.getElement(el)); }
    /**Add to start of childrens*/
    prepend(el) { this.el.prepend(this.getElement(el)); }
    /**Add to end of childrens*/
    append(el) { this.el.append(this.getElement(el)); }
    /**Remove this wrapper */
    cut() { if (this.el.parentNode !== null)
        this.el.parentNode.removeChild(this.el); }
    /**
     * Replace this wrapper by another
     * @param {WrapperGS} w
     */
    replace(by) {
        if (this.el.parentNode === null)
            return;
        const el = this.getElement(by);
        this.before(el);
        this.cut();
    }
    ;
    disable() { this.el['disabled'] = true; if (!this.hasClass("disabled"))
        this.addClass("disabled"); }
    ;
    enable() { this.el['disabled'] = false; if (this.hasClass("disabled"))
        this.removeClass("disabled"); }
    ;
    hide() { if (!this.hasClass("d-none"))
        this.addClass("d-none"); }
    ;
    show() { if (this.hasClass("d-none"))
        this.removeClass("d-none"); }
    ;
    showflip() { if (this.isShowed)
        this.hide();
    else
        this.show(); }
    ;
    scrollTo() {
        let e = this.el, posX = 0, posY = 0;
        while (e) {
            posX += e.offsetLeft;
            posY += e.offsetTop;
            e = gs.def.toType(e.offsetParent, HTMLElement);
        }
        window.scrollTo(posX, posY);
    }
    ;
    get text() { return this.el.innerText; }
    set text(value) { this.el.innerText = value; }
    get html() { return this.el.innerHTML; }
    set html(value) { this.el.innerHTML = value; }
    attr(name, value) {
        if (!value)
            if (value !== null)
                return this.el.getAttribute(name);
        if (value === null)
            this.el.removeAttribute(name);
        else
            this.el.setAttribute(name, value);
    }
    attrRemove(name) { this.attr(name, null); }
    /**
     * Return obj this attrs
     * */
    getAttrsObj() {
        const map = new Map();
        let i = 0;
        while (this.el.attributes[i]) {
            const k = this.el.attributes[i].name;
            map.set(k, this.el.getAttribute(k));
            i++;
        }
        return map;
    }
    getData(name) { const d = this.attr('data-' + name); if (!d)
        return '';
    else
        return d; }
    removeData(name) { this.attr('data-' + name, null); }
    setData(name, value) { this.attr('data-' + name, value); }
    getGSA(name) { const d = this.attr('gs-' + name); if (!d)
        return '';
    else
        return d; }
    removeGSA(name) { this.attr('gs-' + name, null); }
    setGSA(name, value) { this.attr('gs-' + name, value); }
    /**Get children without deep */
    getChildren() {
        const list = new ArrayGS_js_1.ArrayGS();
        this.el.childNodes.forEach(e => {
            const wr = gs.w(e);
            if (wr)
                list.push(wr);
        });
        return list;
    }
    /**Get all children include children of children*/
    getAllChildren() {
        const list = new ArrayGS_js_1.ArrayGS();
        function searchChildren(el) {
            el.childNodes.forEach(e => {
                const wr = gs.w(e);
                if (wr)
                    list.push(wr);
                searchChildren(e);
            });
        }
        searchChildren(this.el);
        return list;
    }
    set onclick(value) { this.el.onclick = value; }
}
exports.WrapperGS = WrapperGS;
WrapperGS.AttrDataComponentInject = "cmp";
WrapperGS.AttrDataComponentInjectArgs = "cmp_args";
WrapperGS.AttrDataTemplateNotForInject = "no_inj";
WrapperGS.ClassNameTemplate = "tmpl";
WrapperGS._InjectComponents = new Map();
WrapperGS._ExtendComponentsByTagClass = new Map();
WrapperGS._ExtendComponentsByHTMLElement = new ArrayGS_js_1.ArrayGS();
WrapperGS._ImplementWrapperByGSA = new Map();
WrapperGS._ImplementWrapperByClassArg = new Map();
WrapperGS.ImplementWrapperByGSA('size_ration', (wr) => {
    const ratio = parseFloat(wr.getGSA('size_ratio'));
    const resize = () => { wr.attr('height', (wr.el.clientWidth / ratio).toString()); };
    window.addEventListener('resize', resize);
    setTimeout(resize, 100);
});
WrapperGS.ImplementWrapperByGSA('set_src_after', (wr) => {
    const imgHtml = gs.def.toType(wr.el, HTMLImageElement);
    if (imgHtml)
        imgHtml.src = wr.getGSA('set_src_after');
});
WrapperGS.ImplementWrapperByGSA('scroll_after_focusin', (wr) => {
    const scrollHandler = function (e) {
        const el = e.target;
        if (el.scrollIntoView)
            el.scrollIntoView();
    };
    wr.el.addEventListener('focusin', scrollHandler);
});
//# sourceMappingURL=WrapperGS.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/core/index.js":
/*!************************************************!*\
  !*** ./node_modules/@ivanlog/gs/core/index.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./StateGS */ "./node_modules/@ivanlog/gs/core/StateGS.js"), exports);
__exportStar(__webpack_require__(/*! ./EventsGS */ "./node_modules/@ivanlog/gs/core/EventsGS.js"), exports);
__exportStar(__webpack_require__(/*! ./ArrayGS */ "./node_modules/@ivanlog/gs/core/ArrayGS.js"), exports);
__exportStar(__webpack_require__(/*! ./TemplateGS */ "./node_modules/@ivanlog/gs/core/TemplateGS.js"), exports);
__exportStar(__webpack_require__(/*! ./ComponentGS */ "./node_modules/@ivanlog/gs/core/ComponentGS.js"), exports);
__exportStar(__webpack_require__(/*! ./WrapperGS */ "./node_modules/@ivanlog/gs/core/WrapperGS.js"), exports);
__exportStar(__webpack_require__(/*! ./GS */ "./node_modules/@ivanlog/gs/core/GS.js"), exports);
__exportStar(__webpack_require__(/*! ./Enums */ "./node_modules/@ivanlog/gs/core/Enums.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/ctrls/FocusGroup.js":
/*!******************************************************!*\
  !*** ./node_modules/@ivanlog/gs/ctrls/FocusGroup.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FocusGroup = void 0;
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
const core_1 = __webpack_require__(/*! ../core */ "./node_modules/@ivanlog/gs/core/index.js");
class FocusGroup {
    constructor(wr, groupName = "noname", position = 0) {
        this._handlers = new Map();
        this._list = new core_1.ArrayGS();
        this.groupName = groupName;
        this.add(wr, position);
    }
    static AddItem(wr) {
        const fgData = wr.getGSA(FocusGroup.TagGSA);
        const parser = fgData.split(':');
        const fgName = parser[0];
        let position = 0;
        if (parser.length > 1)
            position = parseInt(parser[1]);
        if (!FocusGroup._Items.has(fgName))
            FocusGroup._Items.set(fgName, new FocusGroup(wr, fgName, position));
        else
            FocusGroup._Items.get(fgName).add(wr, position);
    }
    add(wr, position) {
        //If we have dublicate - clear list;
        if (this._list[position])
            this.clear();
        if (this._handlers.has(wr))
            this.remove(wr);
        wr.setGSA(FocusGroup.TagGSA, `${this.groupName}:${position}`);
        this._handlers.set(wr, new core_1.EventHandlerDisposable(wr, 'keyup', (e) => this._nextFocusHandler(e)));
        this._list[position] = wr;
        return true;
    }
    remove(wr) {
        const handler = this._handlers.get(wr);
        handler.dispose();
        this._handlers.delete(wr);
        this._list.remove(wr);
    }
    clear() {
        for (const h of this._handlers.values())
            h.dispose();
        this._handlers.clear();
        this._list.clear();
    }
    _nextFocusHandler(e) {
        if (e.keyCode !== 13)
            return;
        const wr = gs.w(e.target);
        if (!wr)
            return;
        if (!this._handlers.has(wr))
            return;
        const fgData = wr.getGSA(FocusGroup.TagGSA);
        const parser = fgData.split(':');
        const fgName = parser[0];
        if (this.groupName !== fgName) {
            this.remove(wr);
            return;
        }
        if (wr.el.nodeName === "TEXTAREA")
            if (!e.ctrlKey)
                return;
        for (let i = 0; i < this._list.length; i++)
            if (this._list[i] === wr) {
                const nextI = i + 1;
                if (nextI === this._list.length) {
                    wr.el.blur();
                    return;
                }
                else {
                    const nextWr = this._list[nextI];
                    if (!nextWr)
                        continue;
                    const nextEl = nextWr.el;
                    if (!nextEl.isConnected)
                        continue;
                    if (nextEl.getAttribute('type') === 'submit') {
                        nextEl.click();
                        return;
                    }
                    if (nextEl.nodeName) {
                        if (nextEl.nodeName === "INPUT")
                            nextEl.focus();
                        if (nextEl.nodeName === "TEXTAREA")
                            nextEl.focus();
                    }
                    if (nextEl.click) {
                        nextEl.click();
                        return;
                    }
                    nextEl.focus();
                    return;
                }
            }
    }
}
exports.FocusGroup = FocusGroup;
FocusGroup._Items = new Map();
FocusGroup.TagGSA = 'focus';
gs.WrapperGS.ImplementWrapperByGSA(FocusGroup.TagGSA, FocusGroup.AddItem);
//# sourceMappingURL=FocusGroup.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/ctrls/index.js":
/*!*************************************************!*\
  !*** ./node_modules/@ivanlog/gs/ctrls/index.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./FocusGroup */ "./node_modules/@ivanlog/gs/ctrls/FocusGroup.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/blob.js":
/*!**************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/blob.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.imageFileToResizedBlob = exports.blobToFile = exports.blobToDataURL = exports.dataURLtoBlob = exports.base64toBlob = void 0;
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
function base64toBlob(b64Data, contentType = '', sliceSize = 512) {
    const byteCharacters = atob(b64Data);
    const byteArrays = [];
    for (let offset = 0; offset < byteCharacters.length; offset += sliceSize) {
        const slice = byteCharacters.slice(offset, offset + sliceSize);
        const byteNumbers = new Array(slice.length);
        for (let i = 0; i < slice.length; i++) {
            byteNumbers[i] = slice.charCodeAt(i);
        }
        const byteArray = new Uint8Array(byteNumbers);
        byteArrays.push(byteArray);
    }
    const blob = new Blob(byteArrays, { type: contentType });
    return blob;
}
exports.base64toBlob = base64toBlob;
/**
    * @param {string} dataurl
    * @returns {Blob}
*/
function dataURLtoBlob(dataurl) {
    let arr = dataurl.split(','), mime = arr[0].match(/:(.*?);/)[1], bstr = atob(arr[1]), n = bstr.length, u8arr = new Uint8Array(n);
    while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
    }
    return new Blob([u8arr], { type: mime });
}
exports.dataURLtoBlob = dataURLtoBlob;
/**
    * @param {Blob} blob
    * @returns {Promise<String>}
    */
function blobToDataURL(blob) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            const a = new FileReader();
            a.onload = (e) => { resolve(e.target.result); };
            try {
                a.readAsDataURL(blob);
            }
            catch (e) {
                reject(e);
            }
        });
    });
}
exports.blobToDataURL = blobToDataURL;
/**
    * @param {Blob} blob
    * @param {string} filename
    * @returns {File}
    */
function blobToFile(blob, filename) {
    let file = new File([blob], filename, { type: blob.type, lastModified: Date.now() });
    return file;
}
exports.blobToFile = blobToFile;
/**
* Load image file, then resize it and return blob
*/
function imageFileToResizedBlob(file, maxSize) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            if (!file.type.match(/image.*/))
                reject("not image");
            const reader = new FileReader();
            reader.onload = function (readerEvent) {
                const image = new Image();
                image.onload = function (imageEvent) {
                    // Resize the image
                    let canvas = document.createElement('canvas'), width = image.width, height = image.height;
                    if (width > height) {
                        if (width > maxSize) {
                            height *= maxSize / width;
                            width = maxSize;
                        }
                    }
                    else {
                        if (height > maxSize) {
                            width *= maxSize / height;
                            height = maxSize;
                        }
                    }
                    canvas.width = width;
                    canvas.height = height;
                    canvas.getContext('2d').drawImage(image, 0, 0, width, height);
                    let dataUrl = canvas.toDataURL('image/jpeg');
                    let resizedImage = gs.blob.dataURLtoBlob(dataUrl);
                    resolve(resizedImage);
                };
                image.src = readerEvent.target.result;
            };
            reader.readAsDataURL(file);
        });
    });
}
exports.imageFileToResizedBlob = imageFileToResizedBlob;
//# sourceMappingURL=blob.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/crypt.js":
/*!***************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/crypt.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fromBase64 = exports.toBase64 = exports.bytesToSHA256 = exports.strToSHA256 = exports.hexStringToBytes = exports.bytesToHexString = void 0;
function bytesToHexString(byteArray) {
    return Array.from(byteArray, function (byte) {
        return ('0' + (byte & 0xFF).toString(16)).slice(-2);
    }).join('');
}
exports.bytesToHexString = bytesToHexString;
function hexStringToBytes(hex) {
    const bytes = [];
    for (let c = 0; c < hex.length; c += 2)
        bytes.push(parseInt(hex.substr(c, 2), 16));
    return bytes;
}
exports.hexStringToBytes = hexStringToBytes;
const sha256 = new (function () {
    const chrsz = 8;
    const hexcase = 0;
    function safeAdd(x, y) {
        const lsw = (x & 0xFFFF) + (y & 0xFFFF);
        const msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return (msw << 16) | (lsw & 0xFFFF);
    }
    function S(X, n) { return (X >>> n) | (X << (32 - n)); }
    function R(X, n) { return (X >>> n); }
    function Ch(x, y, z) { return ((x & y) ^ ((~x) & z)); }
    function Maj(x, y, z) { return ((x & y) ^ (x & z) ^ (y & z)); }
    function Sigma0256(x) { return (S(x, 2) ^ S(x, 13) ^ S(x, 22)); }
    function Sigma1256(x) { return (S(x, 6) ^ S(x, 11) ^ S(x, 25)); }
    function Gamma0256(x) { return (S(x, 7) ^ S(x, 18) ^ R(x, 3)); }
    function Gamma1256(x) { return (S(x, 17) ^ S(x, 19) ^ R(x, 10)); }
    function coreSha256(m, l) {
        const K = [0x428A2F98, 0x71374491, 0xB5C0FBCF, 0xE9B5DBA5, 0x3956C25B, 0x59F111F1, 0x923F82A4, 0xAB1C5ED5, 0xD807AA98, 0x12835B01, 0x243185BE, 0x550C7DC3, 0x72BE5D74, 0x80DEB1FE, 0x9BDC06A7, 0xC19BF174, 0xE49B69C1, 0xEFBE4786, 0xFC19DC6, 0x240CA1CC, 0x2DE92C6F, 0x4A7484AA, 0x5CB0A9DC, 0x76F988DA, 0x983E5152, 0xA831C66D, 0xB00327C8, 0xBF597FC7, 0xC6E00BF3, 0xD5A79147, 0x6CA6351, 0x14292967, 0x27B70A85, 0x2E1B2138, 0x4D2C6DFC, 0x53380D13, 0x650A7354, 0x766A0ABB, 0x81C2C92E, 0x92722C85, 0xA2BFE8A1, 0xA81A664B, 0xC24B8B70, 0xC76C51A3, 0xD192E819, 0xD6990624, 0xF40E3585, 0x106AA070, 0x19A4C116, 0x1E376C08, 0x2748774C, 0x34B0BCB5, 0x391C0CB3, 0x4ED8AA4A, 0x5B9CCA4F, 0x682E6FF3, 0x748F82EE, 0x78A5636F, 0x84C87814, 0x8CC70208, 0x90BEFFFA, 0xA4506CEB, 0xBEF9A3F7, 0xC67178F2];
        const HASH = [0x6A09E667, 0xBB67AE85, 0x3C6EF372, 0xA54FF53A, 0x510E527F, 0x9B05688C, 0x1F83D9AB, 0x5BE0CD19];
        const W = new Array(64);
        let a, b, c, d, e, f, g, h;
        let T1, T2;
        m[l >> 5] |= 0x80 << (24 - l % 32);
        m[((l + 64 >> 9) << 4) + 15] = l;
        for (let i = 0; i < m.length; i += 16) {
            a = HASH[0];
            b = HASH[1];
            c = HASH[2];
            d = HASH[3];
            e = HASH[4];
            f = HASH[5];
            g = HASH[6];
            h = HASH[7];
            for (let j = 0; j < 64; j++) {
                if (j < 16)
                    W[j] = m[j + i];
                else
                    W[j] = safeAdd(safeAdd(safeAdd(Gamma1256(W[j - 2]), W[j - 7]), Gamma0256(W[j - 15])), W[j - 16]);
                T1 = safeAdd(safeAdd(safeAdd(safeAdd(h, Sigma1256(e)), Ch(e, f, g)), K[j]), W[j]);
                T2 = safeAdd(Sigma0256(a), Maj(a, b, c));
                h = g;
                g = f;
                f = e;
                e = safeAdd(d, T1);
                d = c;
                c = b;
                b = a;
                a = safeAdd(T1, T2);
            }
            HASH[0] = safeAdd(a, HASH[0]);
            HASH[1] = safeAdd(b, HASH[1]);
            HASH[2] = safeAdd(c, HASH[2]);
            HASH[3] = safeAdd(d, HASH[3]);
            HASH[4] = safeAdd(e, HASH[4]);
            HASH[5] = safeAdd(f, HASH[5]);
            HASH[6] = safeAdd(g, HASH[6]);
            HASH[7] = safeAdd(h, HASH[7]);
        }
        return HASH;
    }
    function str2binb(str) {
        const bin = [];
        const mask = (1 << chrsz) - 1;
        for (let i = 0; i < str.length * chrsz; i += chrsz) {
            bin[i >> 5] |= (str.charCodeAt(i / chrsz) & mask) << (24 - i % 32);
        }
        return bin;
    }
    function bytesToWords(bytes) {
        var words = [];
        for (var i = 0, b = 0; i < bytes.length; i++, b += 8) {
            words[b >>> 5] |= bytes[i] << (24 - b % 32);
        }
        return words;
    }
    function Utf8Encode(string) {
        string = string.replace(/\r\n/g, '\n');
        let utftext = '';
        for (let n = 0; n < string.length; n++) {
            const c = string.charCodeAt(n);
            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
        return utftext;
    }
    function binb2hex(binarray) {
        const hexTab = hexcase ? '0123456789ABCDEF' : '0123456789abcdef';
        let str = '';
        for (let i = 0; i < binarray.length * 4; i++) {
            str += hexTab.charAt((binarray[i >> 2] >> ((3 - i % 4) * 8 + 4)) & 0xF) +
                hexTab.charAt((binarray[i >> 2] >> ((3 - i % 4) * 8)) & 0xF);
        }
        return str;
    }
    this.strToSHA256 = function (s) {
        s = Utf8Encode(s);
        return binb2hex(coreSha256(str2binb(s), s.length * chrsz));
    };
    this.bytesToSHA256 = function (data) {
        return binb2hex(coreSha256(bytesToWords(new Uint8Array(data)), data.byteLength * 8));
    };
});
function strToSHA256(s) {
    return sha256.strToSHA256(s);
}
exports.strToSHA256 = strToSHA256;
function bytesToSHA256(data) {
    return sha256.bytesToSHA256(data);
}
exports.bytesToSHA256 = bytesToSHA256;
function toBase64(str) { return btoa(encodeURIComponent(str)); }
exports.toBase64 = toBase64;
function fromBase64(data) { return decodeURIComponent(window.atob(data)); }
exports.fromBase64 = fromBase64;
/*
export function enUrlDeflateBase64(data: string): string { return btoa(gs.ext.pako.deflateRaw(encodeURIComponent(data), { to: "string" })); }
export function unbase64InflateUrlDec(data: string): string { return decodeURIComponent(gs.ext.pako.inflateRaw(atob(data), {to:"string"})); }
*/
//# sourceMappingURL=crypt.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/date.js":
/*!**************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/date.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getNow = exports.getTime = exports.getDate = exports.getNamedTime = exports.getShortTime = exports.getDayOfYear = void 0;
function addZero(value) { if (value < 10)
    return "0" + value; return "" + value; }
function getDayOfYear(data) {
    const start = new Date(data.getFullYear(), 0, 0);
    const diff = data.getTime() - start.getTime();
    const oneDay = 1000 * 60 * 60 * 24;
    const day = Math.floor(diff / oneDay);
    return day;
}
exports.getDayOfYear = getDayOfYear;
function getShortTime(date) {
    if (!date)
        return "---";
    return addZero(date.getDate()) + '.' + addZero(date.getMonth() + 1) + '.' + addZero(date.getFullYear()) + ' ' + addZero(date.getHours()) + ':' + addZero(date.getMinutes());
}
exports.getShortTime = getShortTime;
/**
* Возвращает дату с препиской, сегодня-вчера
* @returns {string}
* @param {Date} date
*/
function getNamedTime(date) {
    if (!date)
        return "---";
    const now = new Date();
    if (date.getFullYear() !== now.getFullYear())
        return addZero(date.getDate()) + '.' + addZero(date.getMonth() + 1) + '.' + addZero(date.getFullYear()) + ' ' + addZero(date.getHours()) + ':' + addZero(date.getMinutes());
    const nowDays = this.getDayOfYear(now);
    const dateDays = this.getDayOfYear(date);
    const delta = nowDays - dateDays;
    switch (delta) {
        case 0:
            return 'сегодня ' + addZero(date.getHours()) + ':' + addZero(date.getMinutes());
        case 1:
            return 'вчера ' + addZero(date.getHours()) + ':' + addZero(date.getMinutes());
        case 2:
            return 'позавчера ' + addZero(date.getHours()) + ':' + addZero(date.getMinutes());
    }
    return addZero(date.getDate()) + '.' + addZero(date.getMonth() + 1) + '.' + addZero(date.getFullYear()) + ' ' + addZero(date.getHours()) + ':' + addZero(date.getMinutes());
}
exports.getNamedTime = getNamedTime;
/**
* @returns {string}
* @param {Date} date
*/
function getDate(date) {
    return addZero(date.getDate()) + '.' + addZero(date.getMonth() + 1) + '.' + addZero(date.getFullYear());
}
exports.getDate = getDate;
/**
* @returns {string}
* @param {Date} date
*/
function getTime(date) {
    return addZero(date.getHours()) + ':' + addZero(date.getMinutes());
}
exports.getTime = getTime;
/**
* @returns {Date}
* */
function getNow() {
    return new Date();
}
exports.getNow = getNow;
//# sourceMappingURL=date.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/def.js":
/*!*************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/def.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.argDate = exports.argBool = exports.argString = exports.argFloat = exports.argInt = exports.argSearch = exports.date = exports.bool = exports.string = exports.float = exports.int = exports.hasProp = exports.toType = exports.toUnsafeType = void 0;
const gs = __webpack_require__(/*! ../index */ "./node_modules/@ivanlog/gs/index.js");
/** Cast object to type without check */
function toUnsafeType(obj) { return obj; }
exports.toUnsafeType = toUnsafeType;
/** Cast object to type if he expand it or return undefined if not */
function toType(obj, type) {
    if (!(obj instanceof type))
        return undefined;
    return obj;
}
exports.toType = toType;
function hasProp(wr, propName, type) {
    if (!wr[propName])
        return false;
    if (type) {
        if (type === gs.Types.NotFunction) {
            if ((typeof wr === gs.Types.Function) ||
                (typeof wr === gs.Types.Undefined))
                return false;
            return true;
        }
        if (typeof wr !== type)
            return false;
    }
    return true;
}
exports.hasProp = hasProp;
/** Cast argument to integer or return default */
function int(arg, def = 0) { if (!arg)
    return def; return parseInt(arg); }
exports.int = int;
/** Cast argument to float or return default */
function float(arg, def = 0.0) { if (!arg)
    return def; return parseFloat(arg); }
exports.float = float;
/** Cast argument to string or return default */
function string(arg, def = '') { if (!arg)
    return def; return arg.toString(); }
exports.string = string;
/** Cast argument to boolean or return default */
function bool(arg) { if (!arg)
    return false; let a = arg.toString(); a = a.toLowerCase(); if (a === 'true' || a === '1' || a === 't')
    return true; return false; }
exports.bool = bool;
/** Cast argument to Date or return default */
function date(arg, def = new Date()) {
    if (!arg)
        return def;
    let date = new Date(arg);
    if (!date.getDate) {
        date = new Date();
        const dt = arg.split(' ');
        const d = dt[0].split('-');
        const t = dt[1].split(':');
        date.setFullYear(parseInt(d[0]));
        date.setMonth(parseInt(d[1]) - 1);
        date.setDate(parseInt(d[2]));
        date.setHours(parseInt(t[0]));
        date.setMinutes(parseInt(t[1]));
        date.setSeconds(parseInt(t[2]));
    }
    return date;
}
exports.date = date;
/** Trying found arg of object in various cases */
function argSearch(name, obj) {
    if (obj[name])
        return obj[name];
    const nameCap = name.charAt(0).toUpperCase() + name.slice(1);
    if (obj[nameCap])
        return obj[nameCap];
    const nameLow = name.toLowerCase();
    if (obj[nameLow])
        return obj[nameLow];
    return undefined;
}
exports.argSearch = argSearch;
/** Search and cast object argument to integer */
function argInt(name, obj, def = 0) { const arg = argSearch(name, obj); return int(arg, def); }
exports.argInt = argInt;
/** Search and cast object argument to float */
function argFloat(name, obj, def = 0.0) { const arg = argSearch(name, obj); return float(arg, def); }
exports.argFloat = argFloat;
/** Search and cast object argument to string */
function argString(name, obj, def = '') { const arg = argSearch(name, obj); return string(arg, def); }
exports.argString = argString;
/** Search and cast object argument to string */
function argBool(name, obj) { const arg = argSearch(name, obj); return bool(arg); }
exports.argBool = argBool;
/** Search and cast object argument to string */
function argDate(name, obj) { const arg = argSearch(name, obj); return date(arg); }
exports.argDate = argDate;
//# sourceMappingURL=def.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/enums.js":
/*!***************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/enums.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IsInEnum = void 0;
function IsInEnum(type, enumObj) {
    return Object.values(type).includes(enumObj);
    /*
    for (const arg in Object.values(enumObj))
        if (arg === type) return true;
    return false;*/
}
exports.IsInEnum = IsInEnum;
//# sourceMappingURL=enums.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/events.js":
/*!****************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/events.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.stop = void 0;
function stop(e) {
    e.preventDefault();
    e.stopPropagation();
}
exports.stop = stop;
;
//# sourceMappingURL=events.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/files.js":
/*!***************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/files.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.readAsArrayBufferAsync = exports.readAsDataURLAsync = exports.readFileAsTextAsync = void 0;
function readFileAsTextAsync(file) {
    // Always return a Promise
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onloadend = function (e) { resolve(e.target.result); };
        reader.onerror = function (e) { reject(e.target.error.message); };
        reader.readAsText(file);
    });
}
exports.readFileAsTextAsync = readFileAsTextAsync;
function readAsDataURLAsync(file) {
    // Always return a Promise
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onloadend = function (e) { resolve(e.target.result); };
        reader.onerror = function (e) { reject(e.target.error.message); };
        reader.readAsDataURL(file);
    });
}
exports.readAsDataURLAsync = readAsDataURLAsync;
function readAsArrayBufferAsync(file) {
    // Always return a Promise
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onloadend = function (e) { resolve(e.target.result); };
        reader.onerror = function (e) { reject(e.target.error.message); };
        reader.readAsArrayBuffer(file);
    });
}
exports.readAsArrayBufferAsync = readAsArrayBufferAsync;
//# sourceMappingURL=files.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/generators.js":
/*!********************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/generators.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createHexString = exports.createPassword = void 0;
const _passChr = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 1, 2, 3, 4, 5, 6, 7, 8, 9];
function rndChr(x, y, z) { let num; const work = true; do {
    num = Math.round((Math.random() * z));
    if (num >= x && num <= y)
        break;
} while (work); return (num); }
function createPassword(size = 8) { let pass = ''; for (let i = 0; i < size; i++)
    pass += _passChr[rndChr(0, 32, 100)]; return pass; }
exports.createPassword = createPassword;
function createHexString(size = 32) {
    let hex = '';
    for (let i = 0; i < size; i++) {
        const int = Math.floor(Math.random() * 16);
        hex += int.toString(16);
    }
    return hex;
}
exports.createHexString = createHexString;
//# sourceMappingURL=generators.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/html.js":
/*!**************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/html.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.textToElement = exports.tag = exports.img = exports.hr = exports.br = exports.div = exports.a = exports.p = exports.span = exports.addSpace = exports.addText = exports.addAttrs = void 0;
function addAttrs(el, attrs) { if (!attrs)
    return; for (const attr in attrs) {
    el.setAttribute(attr, attrs[attr]);
} }
exports.addAttrs = addAttrs;
function addText(el, text) { el.appendChild(document.createTextNode(text)); }
exports.addText = addText;
;
function addSpace(el) { el.appendChild(document.createTextNode(' ')); }
exports.addSpace = addSpace;
function createAndFillElement(tag, inner = "", attrs = {}) {
    const el = document.createElement(tag);
    el.innerHTML = inner;
    addAttrs(el, attrs);
    return el;
}
function span(attrs = {}, inner = "") { return createAndFillElement('span', inner, attrs); }
exports.span = span;
;
function p(attrs = {}, inner = "") { return createAndFillElement('p', inner, attrs); }
exports.p = p;
;
function a(attrs = {}, inner = "") { return createAndFillElement('a', inner, attrs); }
exports.a = a;
;
function div(attrs = {}, inner = "") { return createAndFillElement('div', inner, attrs); }
exports.div = div;
;
function br(attrs = {}) { const el = document.createElement('br'); addAttrs(el, attrs); return el; }
exports.br = br;
;
function hr(attrs = {}) { const el = document.createElement('hr'); addAttrs(el, attrs); return el; }
exports.hr = hr;
;
function img(attrs = {}) { const el = document.createElement('img'); addAttrs(el, attrs); return el; }
exports.img = img;
;
function tag(tagName, attrs = {}, inner = '') { const el = document.createElement(tagName); addAttrs(el, attrs); el.innerHTML = inner; return el; }
exports.tag = tag;
;
function textToElement(text) {
    return div({}, text).firstElementChild;
}
exports.textToElement = textToElement;
//# sourceMappingURL=html.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/index.js":
/*!***************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validation = exports.crypt = exports.text = exports.enums = exports.blob = exports.date = exports.events = exports.files = exports.def = exports.web = exports.generators = exports.html = void 0;
const htmlImport = __webpack_require__(/*! ./html */ "./node_modules/@ivanlog/gs/helpers/html.js");
const generatorsImport = __webpack_require__(/*! ./generators */ "./node_modules/@ivanlog/gs/helpers/generators.js");
const defImport = __webpack_require__(/*! ./def */ "./node_modules/@ivanlog/gs/helpers/def.js");
const eventsImport = __webpack_require__(/*! ./events */ "./node_modules/@ivanlog/gs/helpers/events.js");
const dateImport = __webpack_require__(/*! ./date */ "./node_modules/@ivanlog/gs/helpers/date.js");
const webImport = __webpack_require__(/*! ./web */ "./node_modules/@ivanlog/gs/helpers/web.js");
const enumsImport = __webpack_require__(/*! ./enums */ "./node_modules/@ivanlog/gs/helpers/enums.js");
const validationImport = __webpack_require__(/*! ./validation */ "./node_modules/@ivanlog/gs/helpers/validation.js");
const blobImport = __webpack_require__(/*! ./blob */ "./node_modules/@ivanlog/gs/helpers/blob.js");
const textImport = __webpack_require__(/*! ./text */ "./node_modules/@ivanlog/gs/helpers/text.js");
const cryptImport = __webpack_require__(/*! ./crypt */ "./node_modules/@ivanlog/gs/helpers/crypt.js");
const filesImport = __webpack_require__(/*! ./files */ "./node_modules/@ivanlog/gs/helpers/files.js");
exports.html = htmlImport;
exports.generators = generatorsImport;
exports.web = webImport;
exports.def = defImport;
exports.files = filesImport;
exports.events = eventsImport;
exports.date = dateImport;
exports.blob = blobImport;
exports.enums = enumsImport;
exports.text = textImport;
exports.crypt = cryptImport;
exports.validation = validationImport;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/text.js":
/*!**************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/text.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.copyToClipboard = exports.createUrlArgs = exports.parsePath = exports.parseHost = exports.replaceAll = exports.htmlDecode = exports.clearHtmlToText = exports.lowercaseFirstLetter = exports.uppercaseFirstLetter = exports.formalForNumber = void 0;
const gs = __webpack_require__(/*! .. */ "./node_modules/@ivanlog/gs/index.js");
/** Clear string for parse to number */
function formalForNumber(value) {
    if (!value)
        return value;
    let result = value;
    result = result.replace(/[,]/g, '.');
    result = result.replace(/[^-.,\d]/g, '');
    return result;
}
exports.formalForNumber = formalForNumber;
function uppercaseFirstLetter(string) { return string.charAt(0).toUpperCase() + string.slice(1); }
exports.uppercaseFirstLetter = uppercaseFirstLetter;
function lowercaseFirstLetter(string) { return string.charAt(0).toLowerCase() + string.slice(1); }
exports.lowercaseFirstLetter = lowercaseFirstLetter;
function clearHtmlToText(html) {
    return html.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
}
exports.clearHtmlToText = clearHtmlToText;
function htmlDecode(text) { return gs.html.p(text).textContent; }
exports.htmlDecode = htmlDecode;
;
function replaceAll(str, target, replace) {
    return str.replace(new RegExp(target, 'g'), replace);
}
exports.replaceAll = replaceAll;
function parseHost(url) {
    const a = gs.html.a({ href: url });
    return a.host;
}
exports.parseHost = parseHost;
function parsePath(url) {
    const a = gs.html.a({ href: url });
    return a.pathname;
}
exports.parsePath = parsePath;
function createUrlArgs(data) {
    const urlArgs = [];
    for (const key in data)
        urlArgs.push(`${key}=${encodeURIComponent(data[key])}`);
    return urlArgs.join('&');
}
exports.createUrlArgs = createUrlArgs;
;
function copyToClipboard(text) {
    const textarea = document.createElement("textarea");
    textarea.textContent = text;
    textarea.style.position = "fixed";
    document.body.appendChild(textarea);
    textarea.focus();
    textarea.select();
    const successful = document.execCommand('copy');
    gs.w(textarea).cut();
    return successful;
}
exports.copyToClipboard = copyToClipboard;
;
//# sourceMappingURL=text.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/validation.js":
/*!********************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/validation.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.valueSame = exports.valueIsEmail = exports.valueIsPhone = exports.valueMaxLength = exports.valueMinLength = exports.valueLength = exports.valueNotNumber = exports.valueNumberUInt = exports.valueNumberInt = exports.valueNumberMin = exports.valueNumberMax = exports.valueIsNumber = exports.valueRequired = exports.isNumber = exports.validEmailReg = exports.validPhoneReg = void 0;
const gs = __webpack_require__(/*! ../index */ "./node_modules/@ivanlog/gs/index.js");
exports.validPhoneReg = '^[0-9]+$'; //'(7|8|38|37|07)[0-9]{3}[0-9]{7}'
exports.validEmailReg = '.+@.+\..+'; //'(7|8|38|37|07)[0-9]{3}[0-9]{7}'
function isNumber(val) { const num = parseFloat(val); return (!isNaN(num) && isFinite(num)); }
exports.isNumber = isNumber;
function valueRequired(wr) {
    if (!wr)
        return "Введите значение!";
    const checkBox = gs.def.toType(wr, gs.CheckBox);
    let imageEditor;
    let htmlContentEditor;
    if (checkBox) {
        if (!checkBox.value)
            return "Укажите значение!";
        return true;
    }
    if (imageEditor) {
        if (!imageEditor.valid())
            return "Загрузите фото!";
        return true;
    }
    if (htmlContentEditor) {
        const htmlVal = htmlContentEditor.getHtml();
        if (htmlVal === '<br>' || htmlVal === '') {
            return "Введите значение!";
        }
        return true;
    }
    if ((wr.value === undefined) || (!wr.value))
        return "Введите значение!";
    return true;
}
exports.valueRequired = valueRequired;
function valueIsNumber(wr) {
    if (!wr.value)
        return "Введите число!";
    wr.value = wr.value.replace(/[,]/g, '.');
    const n = parseFloat(wr.value);
    if (!(!isNaN(n) && isFinite(n))) {
        wr.value = wr.value.replace(/[^-.,\d]/g, '');
        return "Введите число!";
    }
    return true;
}
exports.valueIsNumber = valueIsNumber;
function valueNumberMax(wr, max) {
    const valid = valueIsNumber(wr);
    if (typeof valid === "string")
        return valid;
    const value = parseFloat(wr.value);
    if (value > max)
        return `Максимальный размер ${max}!`;
    return true;
}
exports.valueNumberMax = valueNumberMax;
function valueNumberMin(wr, min) {
    const valid = valueIsNumber(wr);
    if (typeof valid === "string")
        return valid;
    const value = parseFloat(wr.value);
    if (value < min)
        return `Минимальный размер ${min}!`;
    return true;
}
exports.valueNumberMin = valueNumberMin;
function valueNumberInt(wr) {
    const valid = valueIsNumber(wr);
    if (typeof valid === "string")
        return valid;
    wr.value = wr.value.replace(/[^\d]/g, '');
    const value = parseInt(wr.value);
    if ((isNaN(value))) {
        return `Нужно ввести целое число!`;
    }
    return true;
}
exports.valueNumberInt = valueNumberInt;
function valueNumberUInt(wr) {
    const valid = valueNumberInt(wr);
    if (typeof valid === "string")
        return valid;
    const value = parseInt(wr.value);
    if ((value < 0) || (isNaN(value))) {
        return `Нужно ввести целое положительное число!`;
    }
    return true;
}
exports.valueNumberUInt = valueNumberUInt;
function valueNotNumber(wr) {
    const valid = valueIsNumber(wr);
    if (typeof valid === "boolean")
        return `Введите не только цифры!`;
    return true;
}
exports.valueNotNumber = valueNotNumber;
function valueLength(wr, length) {
    const valid = valueRequired(wr);
    if (typeof valid === "string")
        return valid;
    if (typeof wr.value === "string") {
        if (wr.value.length !== length)
            return `Нужно ввести ${length} символа!`;
    }
    if (Array.isArray(wr.value)) {
        if (wr.value.length !== length)
            return `Нужно ${length} элементов!`;
    }
    return true;
}
exports.valueLength = valueLength;
function valueMinLength(wr, length) {
    const valid = valueRequired(wr);
    if (typeof valid === "string")
        return valid;
    if (typeof wr.value === "string") {
        if (wr.value.length < length)
            return `Не менее ${length} символов!`;
    }
    if (Array.isArray(wr.value)) {
        if (wr.value.length < length)
            return `Не менее ${length} элементов!`;
    }
    return true;
}
exports.valueMinLength = valueMinLength;
function valueMaxLength(wr, length) {
    const valid = valueRequired(wr);
    if (typeof valid === "string")
        return valid;
    if (typeof wr.value === "string") {
        if (wr.value.length > length)
            return `Не более ${length} символов!`;
    }
    if (Array.isArray(wr.value)) {
        if (wr.value.length > length)
            return `Не более ${length} элементов!`;
    }
    return true;
}
exports.valueMaxLength = valueMaxLength;
function valueIsPhone(wr) {
    const valid = valueRequired(wr);
    if (typeof valid === "string")
        return valid;
    if (!wr.value.match(exports.validPhoneReg)) {
        if (wr.value)
            wr.value = wr.value.replace(/[^\d]/g, '');
        return `Введите номер телефона в нужном формате!`;
    }
    return true;
}
exports.valueIsPhone = valueIsPhone;
function valueIsEmail(wr) {
    const valid = valueRequired(wr);
    if (typeof valid === "string")
        return valid;
    if (!wr.value.match(exports.validEmailReg)) {
        if (wr.value)
            wr.value = wr.value.replace(/[^\d]/g, '');
        return `Введите email в нужном формате!`;
    }
    return true;
}
exports.valueIsEmail = valueIsEmail;
function valueSame(wr, wrAnother) {
    if (wr.value !== wrAnother.value)
        return `Введите одинаковое значение!`;
    return true;
}
exports.valueSame = valueSame;
//# sourceMappingURL=validation.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/helpers/web.js":
/*!*************************************************!*\
  !*** ./node_modules/@ivanlog/gs/helpers/web.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.deleteCookie = exports.setCookie = exports.getCookie = exports.getUrlArgs = exports.parseUrlArgs = exports.changeUrl = exports.redirect = void 0;
function redirect(url) { window.location.href = url; }
exports.redirect = redirect;
;
function changeUrl(url, state = {}, title = '') { window.history.replaceState(state, title, url); }
exports.changeUrl = changeUrl;
;
function parseUrlArgs(url) {
    const args = {};
    let t = url.split("?");
    if (t.length !== 2)
        return args;
    t = t[1].split("#");
    t[0].split("&").forEach(function (arg) {
        const parser = arg.split("=");
        if (parser.length < 2)
            return;
        const name = parser[0];
        parser.shift();
        args[name] = decodeURIComponent(parser.join('='));
    });
    return args;
}
exports.parseUrlArgs = parseUrlArgs;
function getUrlArgs() { return parseUrlArgs(window.location.search); }
exports.getUrlArgs = getUrlArgs;
function getCookie(name) {
    const matches = document.cookie.match(new RegExp("(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"));
    return matches ? decodeURIComponent(matches[1]) : undefined;
}
exports.getCookie = getCookie;
function setCookie(name, value, options = {}) {
    options = Object.assign({ path: '/' }, options);
    if (options.expires.toUTCString) {
        options.expires = options.expires.toUTCString();
    }
    let updatedCookie = encodeURIComponent(name) + "=" + encodeURIComponent(value);
    for (let optionKey in options) {
        updatedCookie += "; " + optionKey;
        let optionValue = options[optionKey];
        if (optionValue !== true) {
            updatedCookie += "=" + optionValue;
        }
    }
    document.cookie = updatedCookie;
}
exports.setCookie = setCookie;
function deleteCookie(name) {
    this.setCookie(name, "", { 'max-age': -1 });
}
exports.deleteCookie = deleteCookie;
//# sourceMappingURL=web.js.map

/***/ }),

/***/ "./node_modules/@ivanlog/gs/index.js":
/*!*******************************************!*\
  !*** ./node_modules/@ivanlog/gs/index.js ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.q = exports.w = exports.helpers = exports.ctrls = exports.com = void 0;
__exportStar(__webpack_require__(/*! ./core */ "./node_modules/@ivanlog/gs/core/index.js"), exports);
__exportStar(__webpack_require__(/*! ./helpers/index */ "./node_modules/@ivanlog/gs/helpers/index.js"), exports);
__exportStar(__webpack_require__(/*! ./com */ "./node_modules/@ivanlog/gs/com/index.js"), exports);
__exportStar(__webpack_require__(/*! ./ctrls */ "./node_modules/@ivanlog/gs/ctrls/index.js"), exports);
const core_1 = __webpack_require__(/*! ./core */ "./node_modules/@ivanlog/gs/core/index.js");
const gsLib = __webpack_require__(/*! ./index */ "./node_modules/@ivanlog/gs/index.js");
const comLib = __webpack_require__(/*! ./com */ "./node_modules/@ivanlog/gs/com/index.js");
const ctrlsLib = __webpack_require__(/*! ./ctrls */ "./node_modules/@ivanlog/gs/ctrls/index.js");
const helpersLib = __webpack_require__(/*! ./helpers/index */ "./node_modules/@ivanlog/gs/helpers/index.js");
exports.com = comLib;
exports.ctrls = ctrlsLib;
exports.helpers = helpersLib;
/**
* Wrap element in WrapperGs
* @param el
* @param asTmpl Skip specializing for element and wrap raw Element
*/
function w(el, asTmpl = false) { return core_1.WrapperGS.Wrap(el, asTmpl); }
exports.w = w;
function q(selector) { return core_1.GS.Query(selector); }
exports.q = q;
globalThis.gs = gsLib;
//# sourceMappingURL=index.js.map

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
var exports = __webpack_exports__;
/*!**********************!*\
  !*** ./bin/index.js ***!
  \**********************/
﻿
Object.defineProperty(exports, "__esModule", ({ value: true }));
const App_1 = __webpack_require__(/*! ./classes/App */ "./bin/classes/App.js");
const modalCom = __webpack_require__(/*! @ivanlog/gs-com-modal_dialogs */ "./node_modules/@ivanlog/gs-com-modal_dialogs/index.js");
const tmpls_1 = __webpack_require__(/*! ./classes/com/tmpls */ "./bin/classes/com/tmpls.js");
const gs_1 = __webpack_require__(/*! @ivanlog/gs */ "./node_modules/@ivanlog/gs/index.js");
gs_1.FormGS.TagClassName = 'up-form';
gs_1.WrapperGS.ExtendComponentsByTagClass(gs_1.FormGS);
modalCom.Implement();
modalCom.AbstractDialog.HtmlTemplate = (new tmpls_1.ModalDialog).html;
globalThis.app = new App_1.App();
//# sourceMappingURL=index.js.map
})();

/******/ })()
;
//# sourceMappingURL=app.js.map